/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.app.mainplugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.status.IExtensionStatus;
import org.gvsig.andami.plugins.status.IUnsavedData;
import org.gvsig.andami.plugins.status.UnsavedData;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.evalexpression.EvaluateExpressionPanel;
import org.gvsig.app.extension.evalexpression.notifierfactory.AbstractUpdaterFactory;
import org.gvsig.app.extension.evalexpression.notifierfactory.UpdaterFactory;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.toc.actions.EndEditingTocMenuEntry;
import org.gvsig.app.project.documents.view.toc.actions.StartEditingTocMenuEntry;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlCreationListener;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dynform.spi.DynFormSPILocator;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.future.FutureUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.utils.swing.threads.IMonitorableTask;
import org.gvsig.vectorediting.app.mainplugin.EditingBookmarks;
import org.gvsig.vectorediting.app.mainplugin.EditingToolOptionsPanel;
import org.gvsig.vectorediting.app.mainplugin.MultilayerFinishEditingPanel;
import org.gvsig.vectorediting.app.mainplugin.dynformfield.point.JDynFormFieldPointFactory;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.EditingSwingLocator;
import org.gvsig.vectorediting.swing.api.EditingSwingManager;
import org.gvsig.vectorediting.swing.api.console.EditingConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditingExtension
extends Extension
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditingExtension.class);
    private VectorEditingUpdaterFactory vectorEditingUpdaterFactory;

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String actionCommand, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        IView view = this.getActiveView();
        EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
        if (view != null) {
            EditingContext editingContext = swingManager.getEditingContext(view.getMapControl());
            if ("start-editing".equals(actionCommand)) {
                this.doStartEditing(view, editingContext);
            } else if ("end-editing".equals(actionCommand)) {
                this.doEndEditing(view, editingContext);
            } else if ("vector-editing-tooloptions".equalsIgnoreCase(actionCommand)) {
                int modifiers = (Integer)arguments.get("awtmodifiers", Integer.class, (Object)0);
                this.doToolOptions(editingContext, (modifiers & 1) == 1);
            } else if ("vector-editing-ortomode-enable".equalsIgnoreCase(actionCommand)) {
                editingContext.setDrawMode(1);
            } else if ("vector-editing-ortomode-disable".equalsIgnoreCase(actionCommand)) {
                editingContext.setDrawMode(0);
            }
        }
    }

    private void doStartEditing(IView view, EditingContext editingContext) {
        boolean showwarn;
        ApplicationManager application = ApplicationLocator.getManager();
        MapControl mapControl = view.getMapControl();
        List<FLyrVect> reprojectedLayers = this.getActiveLayers(view, layer -> this.canBeEdited((FLyrVect)layer) && !mapControl.getProjection().equals(layer.getProjection()));
        boolean bl = showwarn = !reprojectedLayers.isEmpty();
        if (showwarn && FutureUtils.use((String)"ALLOW_SAVE_ON_REPROJECTED_LAYER")) {
            showwarn = false;
        }
        if (showwarn) {
            String msg = "_The_layer_is_reproyected_on_the_fly_Not_all_editing_tools_work_properly_When_you_finish_editing_will_only_export_the_changes_to_another_layer";
            application.messageDialog(msg, "_Warning", 2);
        } else {
            List<FLyrVect> nonWritableLayers = this.getActiveLayers(view, layer -> this.canBeEdited((FLyrVect)layer) && !this.isWritable((FLyrVect)layer));
            if (!nonWritableLayers.isEmpty()) {
                String msg = "_The_layer_can_not_be_written_When_you_finish_editing_will_only_export_the_changes_to_another_layer";
                application.messageDialog(msg, "_Warning", 2);
            }
        }
        List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> this.canBeEdited((FLyrVect)layer));
        for (FLyrVect layer2 : activeLayers) {
            editingContext.beginEdition(layer2);
            editingContext.addObserver((Observer)this);
        }
        EditingConsole console = editingContext.getConsolePanel();
        JPopupMenu popup = console.getComponentPopupMenu();
        boolean needadd = true;
        for (int i = 0; i < popup.getComponentCount(); ++i) {
            Component comp = popup.getComponent(i);
            if (!StringUtils.equals((String)"ExpressionBuilder", (String)comp.getName())) continue;
            needadd = false;
            break;
        }
        if (needadd) {
            JMenuItem entry = new JMenuItem(new ExpressionBuilderAction(editingContext, console));
            entry.setName("ExpressionBuilder");
            popup.add(entry);
        }
        ApplicationLocator.getManager().refreshMenusAndToolBars();
    }

    private void doEndEditing(IView view, EditingContext editingContext) {
        List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> layer.isEditing());
        if (CollectionUtils.isEmpty(activeLayers)) {
            return;
        }
        if (activeLayers.size() == 1) {
            editingContext.endEdition(activeLayers.get(0));
            ApplicationLocator.getManager().refreshMenusAndToolBars();
        } else {
            this.showMultilaterFinishEditingPanel(view.getMapControl().getMapContext());
        }
    }

    private void doToolOptions(EditingContext editingContext, boolean externalWindow) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (editingContext == null) {
            return;
        }
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        EditingToolOptionsPanel panel = new EditingToolOptionsPanel(editingContext);
        windowManager.showWindow((JComponent)panel, i18n.getTranslation("_Vector_editing_tool_options"), externalWindow ? WindowManager.MODE.SDIWINDOW : WindowManager.MODE.TOOL);
    }

    public void initialize() {
        this.registerIcons();
        DefaultViewPanel.setDisableConsole((boolean)true);
        ExtensionPoint exPoint = ToolsLocator.getExtensionPointManager().add("View_TocActions", "");
        exPoint.append("StartEditing", "TOC popup menu to start vector layer's editing", (ExtensionBuilder)new StartEditingTocMenuEntry());
        exPoint.append("EndEditing", "TOC popup menu to end vector layer's editing", (ExtensionBuilder)new EndEditingTocMenuEntry());
        EditingToolOptionsPanel.registerPersistence();
        this.vectorEditingUpdaterFactory = new VectorEditingUpdaterFactory();
        EvaluateExpressionPanel.registerUpdater((UpdaterFactory)this.vectorEditingUpdaterFactory);
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"vectorediting-tools", (String)"vector-editing", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"vectorediting-tools", (String)"vector-editing-tooloptions", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"vectorediting-tools", (String)"vector-editing-ortomode-enable", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"vectorediting-tools", (String)"vector-editing-ortomode-disable", (Object)((Object)this));
    }

    public void postInitialize() {
        super.postInitialize();
        this.registerSymbols();
        MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
        mapControlManager.addMapControlCreationListener(new MapControlCreationListener(){

            public MapControl mapControlCreated(MapControl mapControl) {
                EditingContext editingContext = EditingSwingLocator.getSwingManager().getEditingContext(mapControl);
                StatusBarListener sbl = new StatusBarListener(mapControl);
                editingContext.setDefaultBehaviors(new Behavior[]{new MouseMovementBehavior((PointListener)sbl)});
                editingContext.addObserver((Observer)EditingExtension.this);
                ApplicationLocator.getManager().refreshMenusAndToolBars();
                return mapControl;
            }
        });
        DynFormSPIManager dynFormManager = DynFormSPILocator.getDynFormSPIManager();
        dynFormManager.registerDynFieldFactory((JDynFormFieldFactory)new JDynFormFieldPointFactory());
        PluginsManager pluginManager = PluginsLocator.getManager();
        pluginManager.addStartupTask("InitializeVectorEditingHistoryAndBookmarks", new Runnable(){

            @Override
            public void run() {
                EditingBookmarks.registerDefaultEditingBookmarks();
            }
        }, false, 99);
    }

    private void registerSymbols() {
        EditingProviderManager providerManager = EditingProviderLocator.getProviderManager();
        SymbolManager symbolManager = MapContextLocator.getSymbolManager();
        File symbolsFolder = FileUtils.getFile((File)this.getPlugin().getPluginDirectory(), (String[])new String[]{"symbols", "editing"});
        ISymbol[] symbols = null;
        try {
            symbols = symbolManager.loadSymbols(symbolsFolder);
        }
        catch (SymbolException e) {
            LOGGER.warn("No symbols loaded from " + symbolsFolder.getAbsolutePath(), (Throwable)e);
        }
        if (symbols != null) {
            for (ISymbol symbol : symbols) {
                String description = symbol.getDescription();
                providerManager.registerSymbol(description, symbol);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isVisible(String action) {
        IView view = this.getActiveView();
        if (view == null) {
            return false;
        }
        EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
        EditingContext editingContext = swingManager.getEditingContext(view.getMapControl());
        if ("start-editing".equals(action)) {
            List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> !layer.isEditing());
            return !activeLayers.isEmpty();
        }
        if ("vector-editing-ortomode-enable".equals(action)) {
            List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> layer.isEditing());
            return editingContext.getDrawMode() == 0 && !activeLayers.isEmpty();
        }
        if ("vector-editing-ortomode-disable".equals(action)) {
            List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> layer.isEditing());
            return editingContext.getDrawMode() == 1 && !activeLayers.isEmpty();
        }
        List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> layer.isEditing());
        return !activeLayers.isEmpty();
    }

    public boolean isEnabled(String action) {
        IView view = this.getActiveView();
        if (view == null) {
            return false;
        }
        EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
        EditingContext editingContext = swingManager.getEditingContext(view.getMapControl());
        if (editingContext.isProcessing()) {
            return false;
        }
        if ("start-editing".equals(action)) {
            List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> this.canBeEdited((FLyrVect)layer));
            return !activeLayers.isEmpty();
        }
        if ("end-editing".equals(action)) {
            List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> layer.isEditing());
            return !activeLayers.isEmpty();
        }
        if ("vector-editing-tooloptions".equals(action)) {
            List<FLyrVect> activeLayers = this.getActiveLayers(view, layer -> layer.isEditing());
            return !activeLayers.isEmpty();
        }
        if ("vector-editing-ortomode-enable".equals(action)) {
            return editingContext.getDrawMode() == 0;
        }
        if ("vector-editing-ortomode-disable".equals(action)) {
            return editingContext.getDrawMode() == 1;
        }
        return false;
    }

    public boolean canQueryByAction() {
        return true;
    }

    private IView getActiveView() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        return view;
    }

    private boolean isWritable(FLyrVect layer) {
        if (layer != null && layer.isAvailable() && layer.isVisible()) {
            return layer.getFeatureStore().allowWrite();
        }
        return false;
    }

    private boolean canBeEdited(FLyrVect layer) {
        if (layer != null && layer.isAvailable() && layer.isVisible()) {
            FeatureStore store = layer.getFeatureStore();
            boolean storeCanBeEdited = false;
            if (store != null) {
                storeCanBeEdited = store.canBeEdited();
            }
            return storeCanBeEdited && !layer.isEditing();
        }
        return false;
    }

    private List<FLyrVect> getActiveLayers(IView view, Predicate<FLyrVect> valid) {
        FLayer[] actives;
        if (view == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FLyrVect> layers = new ArrayList<FLyrVect>();
        ViewDocument viewDocument = view.getViewDocument();
        for (FLayer layer : actives = viewDocument.getMapContext().getLayers().getActives()) {
            if (!(layer instanceof FLyrVect) || !valid.test((FLyrVect)layer)) continue;
            layers.add((FLyrVect)layer);
        }
        return layers;
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof Notification) {
            ApplicationManager appManager = ApplicationLocator.getManager();
            Notification n = (Notification)notification;
            if (n.isOfType("EditingContext.changeSelectedTool")) {
                String name = (String)n.getValue();
                if (name != null) {
                    LOGGER.trace("Changed selected tool to '{}'", (Object)name);
                    appManager.getMainFrame().setSelectedTool(name);
                    appManager.refreshMenusAndToolBars();
                }
            } else if (n.isOfType("EditingContext.exportLayer")) {
                this.exportLayer((FLyrVect)n.getValue());
            } else if (n.isOfType("EditingContext.refreshTools")) {
                EditingService activeService = ((EditingContext)observable).getActiveService();
                if (activeService != null) {
                    appManager.getMainFrame().setSelectedTool(activeService.getName());
                }
                appManager.refreshMenusAndToolBars();
            }
            this.vectorEditingUpdaterFactory.updateAll(n);
        }
    }

    private void exportLayer(FLyrVect layer) {
        ApplicationManager appManager = ApplicationLocator.getManager();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        ActionInfo action = PluginsLocator.getActionInfoManager().getAction("layer-exportto");
        action.execute(new Object[]{layer, WindowManager.MODE.toInteger((WindowManager.MODE)WindowManager.MODE.DIALOG)});
        String msg = "_Do_you_want_to_finish_editing_If_not_exported_the_data_the_changes_will_be_lost";
        if (appManager.confirmDialog(i18nManager.getTranslation(msg), i18nManager.getTranslation("end_editing"), 0, 3) == 0) {
            try {
                layer.getFeatureStore().cancelEditing();
            }
            catch (Exception e) {
                LOGGER.warn("Can't abort editing of layer '" + layer.getName() + "'.", (Throwable)e);
                msg = "_Cant_finish_editing_See_the_error_log_for_more_information";
                appManager.messageDialog(msg, "_Warning", 2);
            }
        }
    }

    private List<FLyrVect> getEditedLayers() {
        ApplicationManager application = ApplicationLocator.getManager();
        ArrayList<FLyrVect> editedLayers = new ArrayList<FLyrVect>();
        Project project = application.getCurrentProject();
        for (Document document : project.getDocuments(ViewManager.TYPENAME)) {
            ViewDocument view = (ViewDocument)document;
            MapContext mapContext = view.getMapContext();
            if (mapContext == null) continue;
            FLayers layers = mapContext.getLayers();
            for (int j = 0; j < layers.getLayersCount(); ++j) {
                FLyrVect layerVect;
                FLayer lyr = layers.getLayer(j);
                if (!(lyr instanceof FLyrVect) || !(layerVect = (FLyrVect)lyr).isEditing()) continue;
                editedLayers.add(layerVect);
            }
        }
        return editedLayers;
    }

    private List<IUnsavedData> getUnsavedData(List<FLyrVect> editedLayers) {
        ArrayList<IUnsavedData> unsavedData = new ArrayList<IUnsavedData>();
        for (FLyrVect editedLayer : editedLayers) {
            UnsavedLayer unsavedDataLayer = new UnsavedLayer((IExtension)this, editedLayer);
            unsavedData.add((IUnsavedData)unsavedDataLayer);
        }
        return unsavedData;
    }

    public IExtensionStatus getStatus() {
        List<FLyrVect> editedLayers = this.getEditedLayers();
        final List<IUnsavedData> unsavedData = this.getUnsavedData(editedLayers);
        return new IExtensionStatus(){

            public boolean hasUnsavedData() {
                if (unsavedData == null) {
                    return false;
                }
                return !unsavedData.isEmpty();
            }

            public boolean hasRunningProcesses() {
                return false;
            }

            public IUnsavedData[] getUnsavedData() {
                if (unsavedData == null) {
                    return null;
                }
                return unsavedData.toArray(new IUnsavedData[0]);
            }

            public IMonitorableTask[] getRunningProcesses() {
                return null;
            }
        };
    }

    private void showMultilaterFinishEditingPanel(MapContext mapContext) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        MultilayerFinishEditingPanel finishEditingPanel = new MultilayerFinishEditingPanel(mapContext);
        Dialog dialog = windowManager.createDialog(finishEditingPanel.asJComponent(), i18n.getTranslation("end_editing"), i18n.getTranslation("_List_of_layers_to_finish_editing"), 3);
        finishEditingPanel.setDialog(dialog);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                finishEditingPanel.apply();
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    private static class VectorEditingUpdaterFactory
    extends AbstractUpdaterFactory {
        private final Set<VectorEditingUpdater> vectorEditingUpdaters = new HashSet<VectorEditingUpdater>();

        public VectorEditingUpdaterFactory() {
            super("VectorEditing", "Actualizar cuando cambie la edicion vectorial");
        }

        public UpdaterFactory.Updater create(Observer observer) {
            VectorEditingUpdater updater = new VectorEditingUpdater((UpdaterFactory)this, observer);
            return updater;
        }

        public void updateAll(Notification n) {
            for (VectorEditingUpdater vectorEditingUpdater : this.vectorEditingUpdaters) {
                vectorEditingUpdater.update(n);
            }
        }

        private class VectorEditingUpdater
        extends AbstractUpdaterFactory.AbstractUpdater {
            public VectorEditingUpdater(UpdaterFactory factory, Observer observer) {
                super(factory, observer);
            }

            public void add() {
                VectorEditingUpdaterFactory.this.vectorEditingUpdaters.add(this);
            }

            public void remove() {
                VectorEditingUpdaterFactory.this.vectorEditingUpdaters.remove((Object)this);
            }
        }
    }

    private static class ExpressionBuilderAction
    extends AbstractAction {
        private final EditingConsole console;
        private final EditingContext editingContext;

        public ExpressionBuilderAction(EditingContext editingContext, EditingConsole console) {
            this.editingContext = editingContext;
            this.console = console;
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("ActionCommandKey", "CreateJExpressionBuilderAction");
            this.putValue("Name", i18n.getTranslation("_Show_expression_builder"));
            this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("picker-expression"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            JExpressionBuilder panel = ExpressionEvaluatorSwingLocator.getManager().createJExpressionBuilder();
            panel.getConfig().addSymbolTable(this.editingContext.getContextSymbolTable());
            panel.getConfig().setPreviewSymbolTable(this.editingContext.getContextSymbolTable());
            panel.getConfig().setHistory(this.editingContext.getHistoryForInsertPoints());
            panel.getConfig().setBookmarks(this.editingContext.getBookmarksForInsertPoints());
            Dialog dialog = winmgr.createDialog(panel.asJComponent(), i18n.getTranslation("_Expression_builder"), null, 3);
            dialog.addActionListener(e2 -> {
                if (dialog.getAction() == 1) {
                    this.console.addResponseText(panel.getExpression().getPhrase());
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
    }

    private static class UnsavedLayer
    extends UnsavedData {
        private final FLyrVect layer;

        public UnsavedLayer(IExtension extension, FLyrVect layer) {
            super(extension);
            this.layer = layer;
        }

        public String getDescription() {
            return this.layer.getName();
        }

        public String getResourceName() {
            return this.layer.getFeatureStore().getFullName();
        }

        public boolean saveData() {
            FeatureStore featureStore = this.layer.getFeatureStore();
            if (featureStore.isEditing()) {
                try {
                    featureStore.finishEditing();
                    return true;
                }
                catch (DataException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
    }
}

