/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep;

import java.io.StringReader;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.medfoster.sqljep.ASTArray;
import org.medfoster.sqljep.ASTConstant;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.ASTStart;
import org.medfoster.sqljep.ASTVarNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.Node;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.Parser;
import org.medfoster.sqljep.ParserVisitor;
import org.medfoster.sqljep.SimpleNode;
import org.medfoster.sqljep.function.Abs;
import org.medfoster.sqljep.function.AddDate;
import org.medfoster.sqljep.function.AddMonths;
import org.medfoster.sqljep.function.AddTime;
import org.medfoster.sqljep.function.Case;
import org.medfoster.sqljep.function.Ceil;
import org.medfoster.sqljep.function.Concat;
import org.medfoster.sqljep.function.Datediff;
import org.medfoster.sqljep.function.Day;
import org.medfoster.sqljep.function.DayName;
import org.medfoster.sqljep.function.DayOfWeek;
import org.medfoster.sqljep.function.DayOfYear;
import org.medfoster.sqljep.function.Decode;
import org.medfoster.sqljep.function.Floor;
import org.medfoster.sqljep.function.Hour;
import org.medfoster.sqljep.function.IndistinctMatching;
import org.medfoster.sqljep.function.Initcap;
import org.medfoster.sqljep.function.Instr;
import org.medfoster.sqljep.function.LastDay;
import org.medfoster.sqljep.function.Length;
import org.medfoster.sqljep.function.Lower;
import org.medfoster.sqljep.function.Lpad;
import org.medfoster.sqljep.function.Ltrim;
import org.medfoster.sqljep.function.MakeDate;
import org.medfoster.sqljep.function.MakeTime;
import org.medfoster.sqljep.function.Microsecond;
import org.medfoster.sqljep.function.Minute;
import org.medfoster.sqljep.function.Modulus;
import org.medfoster.sqljep.function.Month;
import org.medfoster.sqljep.function.MonthName;
import org.medfoster.sqljep.function.MonthsBetween;
import org.medfoster.sqljep.function.NextDay;
import org.medfoster.sqljep.function.Nvl;
import org.medfoster.sqljep.function.PostfixCommandI;
import org.medfoster.sqljep.function.Power;
import org.medfoster.sqljep.function.Replace;
import org.medfoster.sqljep.function.Round;
import org.medfoster.sqljep.function.Rpad;
import org.medfoster.sqljep.function.Rtrim;
import org.medfoster.sqljep.function.Second;
import org.medfoster.sqljep.function.Sign;
import org.medfoster.sqljep.function.SubDate;
import org.medfoster.sqljep.function.SubTime;
import org.medfoster.sqljep.function.Substring;
import org.medfoster.sqljep.function.ToChar;
import org.medfoster.sqljep.function.ToDate;
import org.medfoster.sqljep.function.ToNumber;
import org.medfoster.sqljep.function.Translate;
import org.medfoster.sqljep.function.Trim;
import org.medfoster.sqljep.function.Trunc;
import org.medfoster.sqljep.function.Upper;
import org.medfoster.sqljep.function.WeekOfYear;
import org.medfoster.sqljep.function.Year;

public abstract class BaseJEP
implements ParserVisitor {
    public static final boolean debug = false;
    public static final HashMap<String, PostfixCommandI> funTab = new HashMap();
    protected final ArrayList<String> errorList = new ArrayList();
    protected Node topNode;
    public final JepRuntime runtime = new JepRuntime(this);
    protected String expression;

    public BaseJEP(String string) {
        if (string == null) {
            throw new IllegalArgumentException("expression can be null");
        }
        this.expression = string;
        this.topNode = null;
        this.runtime.calendar = JepRuntime.threadCalendar.get();
        if (this.runtime.calendar == null) {
            this.runtime.calendar = Calendar.getInstance();
            JepRuntime.threadCalendar.set(this.runtime.calendar);
        }
        this.runtime.dateSymbols = JepRuntime.threadDateFormatSymbols.get();
        if (this.runtime.dateSymbols == null) {
            this.runtime.dateSymbols = new DateFormatSymbols();
            JepRuntime.threadDateFormatSymbols.set(this.runtime.dateSymbols);
        }
    }

    public void clear() {
        this.topNode = null;
        this.errorList.clear();
    }

    public boolean isValid() {
        return this.topNode != null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public abstract Comparable getColumnObject(int var1) throws ParseException;

    public abstract int findColumn(String var1);

    public abstract Map.Entry getVariable(String var1) throws ParseException;

    public static void addFunction(String string, PostfixCommandI postfixCommandI) {
        funTab.put(string, postfixCommandI);
    }

    public static Object removeFunction(String string) {
        return funTab.remove(string);
    }

    boolean hasError() {
        return !this.errorList.isEmpty();
    }

    String getErrorInfo() {
        if (this.hasError()) {
            String string = "";
            for (String string2 : this.errorList) {
                string = string + string2 + "\n";
            }
            return string;
        }
        return null;
    }

    protected final void parseExpression() throws ParseException {
        StringReader stringReader = new StringReader(this.expression);
        Parser parser = new Parser(stringReader);
        try {
            this.errorList.clear();
            this.topNode = parser.parseStream(stringReader, this);
        }
        catch (ParseException parseException) {
            this.topNode = null;
            this.errorList.add(parseException.getMessage());
        }
        catch (Throwable throwable) {
            throw new ParseException(this.toString(), throwable);
        }
        if (this.hasError()) {
            throw new ParseException(this.getErrorInfo());
        }
    }

    public Comparable getValue() throws ParseException {
        if (!this.isValid()) {
            throw new ParseException("Parser is not prepared");
        }
        if (!this.hasError()) {
            this.runtime.stack.setSize(0);
            this.topNode.jjtAccept(this, null);
            if (this.runtime.stack.size() != 1) {
                throw new ParseException("Wrong stack state. Stack size: " + this.runtime.stack.size());
            }
            return this.runtime.stack.pop();
        }
        throw new ParseException(this.getErrorInfo());
    }

    public boolean equals(Object object) {
        if (object instanceof BaseJEP) {
            BaseJEP baseJEP = (BaseJEP)object;
            return this.expression.equals(baseJEP.expression);
        }
        return false;
    }

    public String toString() {
        return this.expression;
    }

    public final Object visit(SimpleNode simpleNode, Object object) throws ParseException {
        return null;
    }

    public final Object visit(ASTStart aSTStart, Object object) throws ParseException {
        return null;
    }

    public final Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        PostfixCommandI postfixCommandI = aSTFunNode.getPFMC();
        if (postfixCommandI == null) {
            throw new ParseException("No function class associated with " + aSTFunNode.getName());
        }
        postfixCommandI.evaluate(aSTFunNode, this.runtime);
        return null;
    }

    public final Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        if (aSTVarNode.index >= 0) {
            this.runtime.stack.push(this.getColumnObject(aSTVarNode.index));
        } else {
            this.runtime.stack.push((Comparable)aSTVarNode.variable.getValue());
        }
        return null;
    }

    public final Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        this.runtime.stack.push(aSTConstant.value);
        return null;
    }

    public final Object visit(ASTArray aSTArray, Object object) throws ParseException {
        aSTArray.childrenAccept(this, null);
        return null;
    }

    static {
        funTab.put("abs", new Abs());
        funTab.put("power", new Power());
        funTab.put("mod", new Modulus());
        funTab.put("substr", new Substring());
        funTab.put("sign", new Sign());
        funTab.put("ceil", new Ceil());
        funTab.put("floor", new Floor());
        funTab.put("trunc", new Trunc());
        funTab.put("round", new Round());
        funTab.put("length", new Length());
        funTab.put("concat", new Concat());
        funTab.put("instr", new Instr());
        funTab.put("trim", new Trim());
        funTab.put("rtrim", new Rtrim());
        funTab.put("ltrim", new Ltrim());
        funTab.put("rpad", new Rpad());
        funTab.put("lpad", new Lpad());
        funTab.put("lower", new Lower());
        funTab.put("upper", new Upper());
        funTab.put("translate", new Translate());
        funTab.put("replace", new Replace());
        funTab.put("initcap", new Initcap());
        funTab.put("value", new Nvl());
        funTab.put("decode", new Decode());
        funTab.put("to_char", new ToChar());
        funTab.put("to_number", new ToNumber());
        funTab.put("imatch", new IndistinctMatching());
        funTab.put("months_between", new MonthsBetween());
        funTab.put("add_months", new AddMonths());
        funTab.put("last_day", new LastDay());
        funTab.put("next_day", new NextDay());
        funTab.put("to_date", new ToDate());
        funTab.put("case", new Case());
        funTab.put("index", new Instr());
        funTab.put("num", new ToNumber());
        funTab.put("chr", new ToChar());
        funTab.put("dayname", new DayName());
        funTab.put("adddate", new AddDate());
        funTab.put("subdate", new SubDate());
        funTab.put("addtime", new AddTime());
        funTab.put("subtime", new SubTime());
        funTab.put("year", new Year());
        funTab.put("month", new Month());
        funTab.put("day", new Day());
        funTab.put("dayofmonth", new Day());
        funTab.put("hour", new Hour());
        funTab.put("minute", new Minute());
        funTab.put("second", new Second());
        funTab.put("microsecond", new Microsecond());
        funTab.put("datediff", new Datediff());
        funTab.put("dayofweek", new DayOfWeek());
        funTab.put("weekofyear", new WeekOfYear());
        funTab.put("dayofyear", new DayOfYear());
        funTab.put("dayname", new DayName());
        funTab.put("monthname", new MonthName());
        funTab.put("makedate", new MakeDate());
        funTab.put("maketime", new MakeTime());
    }
}

