/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.lib.impl.types.httpbasic;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.lib.impl.types.httpbasic.DownloaderHTTPBasicAuthenticationConfig;
import org.gvsig.downloader.spi.AbstractDownloaderCredentials;

public class DownloaderHTTPBasicCredentials
extends AbstractDownloaderCredentials {
    private final String userid;
    private final String password;

    public DownloaderHTTPBasicCredentials(String serviceUrl, String userid, String password) {
        super("HTTP Basic", serviceUrl);
        this.userid = userid;
        this.password = password;
    }

    public String getAuthorizationToken() {
        return "Basic " + Base64.getEncoder().encodeToString((this.userid + ":" + this.password).getBytes(StandardCharsets.UTF_8));
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public DownloaderCredentials createCredentials(String serviceUrl) {
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return null;
        }
        return new DownloaderHTTPBasicCredentials(serviceUrl, this.getUserid(), this.getPassword());
    }

    public DownloaderCredentials createCredentials(DownloaderAuthenticationConfig config) {
        if (!(config instanceof DownloaderHTTPBasicAuthenticationConfig)) {
            return null;
        }
        DownloaderHTTPBasicAuthenticationConfig otherConfig = (DownloaderHTTPBasicAuthenticationConfig)config;
        if (DownloaderManager.urlStartsWith((String)otherConfig.getServiceUrl(), (String)this.getServiceUrl())) {
            return new DownloaderHTTPBasicCredentials(otherConfig.getServiceUrl(), this.getUserid(), this.getPassword());
        }
        return null;
    }
}

