/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.gml;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gdal.gdal.gdal;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Layer;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.gdal.prov.gml.GMLDataExplorerParameters;
import org.gvsig.gdal.prov.gml.GMLDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRDataExplorer;
import org.gvsig.gdal.prov.ogr.OGRDataExplorerParameters;
import org.gvsig.gdal.prov.ogr.OGRNewDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRUnsupportedFormatException;

public class GMLDataExplorer
extends OGRDataExplorer {
    public static final String NAME = "GMLDataExplorer";

    public GMLDataExplorer(OGRDataExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        super(parameters, providerServices);
    }

    protected synchronized DataSource getDataSource() throws OGRUnsupportedFormatException {
        try {
            if (this.parameters instanceof GMLDataExplorerParameters) {
                GMLDataExplorerParameters gmlDataExplorerParameters = (GMLDataExplorerParameters)this.parameters;
                if (gmlDataExplorerParameters.getGfsSchema() != null) {
                    gdal.SetConfigOption((String)"GML_GFS_TEMPLATE", (String)gmlDataExplorerParameters.getGfsSchema().getAbsolutePath());
                }
                DataSource dataSource = super.getDataSource();
                return dataSource;
            }
            throw new IllegalStateException("Parameters of GML Data explorer is not instance of GMLDataExplorerParameters");
        }
        finally {
            gdal.SetConfigOption((String)"GML_GFS_TEMPLATE", null);
        }
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        if (this.getDataStoreProviderNames().contains(storeName)) {
            NewDataStoreParameters newDataStoreParameters = super.getAddParameters(storeName);
            if ("OGRDataStoreProvider".equals(storeName)) {
                return newDataStoreParameters;
            }
            if ("GMLDataStoreProvider".equals(storeName) && newDataStoreParameters instanceof OGRNewDataStoreParameters) {
                ((OGRNewDataStoreParameters)newDataStoreParameters).setDriverName("GML");
                return newDataStoreParameters;
            }
        }
        return null;
    }

    public List getDataStoreProviderNames() {
        List providerNames = super.getDataStoreProviderNames();
        providerNames.add("GMLDataStoreProvider");
        return providerNames;
    }

    public List list(int mode) throws DataException {
        List layerList = this.getLayerList();
        ArrayList<GMLDataStoreParameters> parametersList = new ArrayList<GMLDataStoreParameters>();
        DataManager dataManager = DALLocator.getDataManager();
        GMLDataExplorerParameters gmlDataExplorerParameters = (GMLDataExplorerParameters)this.parameters;
        for (Layer layer : layerList) {
            GMLDataStoreParameters storeParameters = (GMLDataStoreParameters)dataManager.createStoreParameters("GMLDataStoreProvider");
            String connectionString = gmlDataExplorerParameters.getConnectionString();
            File file = gmlDataExplorerParameters.getFile();
            File gfsSchema = gmlDataExplorerParameters.getGfsSchema();
            storeParameters.setConnectionString(connectionString);
            storeParameters.setFile(file);
            storeParameters.setGfsSchema(gfsSchema);
            storeParameters.setLayerName(layer.GetName());
            parametersList.add(storeParameters);
        }
        return parametersList;
    }
}

