/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension;

import java.awt.Dimension;
import java.util.Collections;
import javax.swing.JComponent;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportManager;
import org.gvsig.export.ExportProcess;
import org.gvsig.export.Filter;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.swing.ExportFinishListenerAdapter;
import org.gvsig.export.swing.ExportSwingLocator;
import org.gvsig.export.swing.ExportSwingManager;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportTable.class);

    public void showExport(FeatureStore featureStore, FeatureQuery query) {
        this.showExport(featureStore, query, WindowManager.MODE.WINDOW);
    }

    public void showExport(FeatureStore featureStore, FeatureQuery query, WindowManager.MODE mode) {
        if (mode == null) {
            mode = WindowManager.MODE.WINDOW;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ExportManager manager = ExportLocator.getManager();
        ExportSwingManager swingManager = ExportSwingLocator.getSwingManager();
        final ExportProcess process = manager.createProcess();
        process.setSourceFeatureStore(featureStore);
        process.setContextProjection(null);
        process.setSourceProjection(featureStore.getDefaultFeatureTypeQuietly().getDefaultSRS());
        process.setSourceTransformation(null);
        process.setFeatureQuery(query);
        process.setFilterExpression(query == null ? null : query.getExpressionFilter());
        JExportProcessPanel panel = swingManager.createJExportProcessPanel(process, (Filter)new Filter<ExportServiceFactory>(){

            public boolean apply(ExportServiceFactory factory) {
                return factory.hasTabularSupport();
            }
        });
        panel.addFinishListener((JExportProcessPanel.ExportFinishListener)new ExportFinishListenerAdapter(){

            public void finished(JExportProcessPanel exportPanel) {
                ExportTable.this.doAddStore(process);
            }
        });
        JComponent component = panel.asJComponent();
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)component, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        winmgr.showWindow(panel.asJComponent(), i18n.getTranslation("_Export_to"), mode, Collections.singletonMap("align", 10));
    }

    public void doAddStore(ExportProcess process) {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (process.getTargetOpenStoreParameters() == null) {
            return;
        }
        int n = application.confirmDialog(i18n.getTranslation("_Add_new_table_to_current_project"), i18n.getTranslation("_Export"), 0, 3, "AddExportedTableToProject");
        if (n != 0) {
            return;
        }
        try {
            DataManager dataManager = DALLocator.getDataManager();
            ProjectManager projectManager = application.getProjectManager();
            Project project = application.getCurrentProject();
            for (OpenDataStoreParameters params : process.getTargetOpenStoreParameters()) {
                FeatureStore store = (FeatureStore)dataManager.openStore(params.getDataStoreName(), (DataStoreParameters)params);
                TableDocument tableDocument = (TableDocument)projectManager.createDocument(TableManager.TYPENAME, store.getName());
                tableDocument.setStore(store);
                project.addDocument((Document)tableDocument);
            }
            application.messageDialog(i18n.getTranslation("_Table_added_to_project"), null, i18n.getTranslation("_Export"), 3, "ExportedTableAddedToProject");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add exported layer to view", (Throwable)ex);
            application.messageDialog(i18n.getTranslation("_Cant_add_exported_table_to_project"), null, i18n.getTranslation("_Export"), 2, "CantAddExportedTableToProject");
        }
    }
}

