/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;

public class CircleEditVertexOperation
implements EditVertexOperation {
    @Override
    public Geometry insertVertex(Primitive geom, int index) throws CreateGeometryException {
        return null;
    }

    @Override
    public Geometry removeVertex(Primitive geom, int index) throws CreateGeometryException {
        return null;
    }

    @Override
    public Geometry moveVertex(Primitive geom, int index, Point point) {
        Circle result = (Circle)geom.cloneGeometry();
        if (index == 0) {
            result.setPoints(point, ((Circle)geom).getRadious());
        } else if (index == 1) {
            result.setPoints(((Circle)geom).getCenter(), point);
        }
        return result;
    }

    @Override
    public List<Point> getVertexesList(Primitive geom) throws CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        ArrayList<Point> vertexList = new ArrayList<Point>();
        Circle circle = (Circle)geom;
        Point center = circle.getCenter();
        vertexList.add(center);
        vertexList.add(geometryManager.createPoint(center.getX() + circle.getRadious(), center.getY(), geom.getGeometryType().getSubType()));
        return vertexList;
    }

    @Override
    public int getNumVertex(Primitive geom) {
        return 2;
    }

    @Override
    public boolean canInsertVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canRemoveVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canMoveVertex(int index, Point point) {
        return true;
    }

    @Override
    public void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Primitive primitive) {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        drawingStatus.addStatus((Geometry)primitive, drawingStatus.getPreviewSymbol(), "");
        drawingStatus.addStatus((Geometry)primitive, polygonSymbolEditing, "");
    }
}

