/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.PeriEllipse;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;

public class EllipseEditVertexOperation
implements EditVertexOperation {
    @Override
    public Geometry insertVertex(Primitive geom, int index) throws CreateGeometryException {
        return null;
    }

    @Override
    public Geometry removeVertex(Primitive geom, int index) throws CreateGeometryException {
        return null;
    }

    @Override
    public Geometry moveVertex(Primitive geom, int index, Point point) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        PeriEllipse original = (PeriEllipse)geom;
        PeriEllipse result = (PeriEllipse)original.cloneGeometry();
        switch (index) {
            case 0: {
                result.setPoints(point, original.getAxis1End(), original.getAxis2Dist());
                break;
            }
            case 1: {
                result.setPoints(original.getAxis1Start(), point, original.getAxis2Dist());
                break;
            }
            case 2: {
                Point axis1Start = original.getAxis1Start();
                Point axis1End = original.getAxis1End();
                Point center = geometryManager.createPoint((axis1Start.getX() + axis1End.getX()) / 2.0, (axis1Start.getY() + axis1End.getY()) / 2.0, geom.getGeometryType().getSubType());
                result.setPoints(original.getAxis1Start(), original.getAxis1End(), center.distance((Geometry)point));
                break;
            }
        }
        return result;
    }

    @Override
    public List<Point> getVertexesList(Primitive geom) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        ArrayList<Point> vertexList = new ArrayList<Point>();
        PeriEllipse ellipse = (PeriEllipse)geom;
        Point axis1Start = ellipse.getAxis1Start();
        vertexList.add(axis1Start);
        Point axis1End = ellipse.getAxis1End();
        vertexList.add(axis1End);
        Point center = geometryManager.createPoint((axis1Start.getX() + axis1End.getX()) / 2.0, (axis1Start.getY() + axis1End.getY()) / 2.0, geom.getGeometryType().getSubType());
        double angle = this.getAngle(axis1Start, axis1End);
        vertexList.add(geometryManager.createPoint(center.getX() + ellipse.getAxis2Dist() * Math.cos(angle + 1.5707963267948966), center.getY() + ellipse.getAxis2Dist() * Math.sin(angle + 1.5707963267948966), geom.getGeometryType().getSubType()));
        return vertexList;
    }

    @Override
    public int getNumVertex(Primitive geom) {
        return 3;
    }

    @Override
    public boolean canInsertVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canRemoveVertex(Primitive geom, int index) {
        return false;
    }

    @Override
    public boolean canMoveVertex(int index, Point point) {
        return true;
    }

    public double getAngle(Point start, Point end) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double angle = Math.acos((end.getX() - start.getX()) / start.distance((Geometry)end));
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    @Override
    public void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Primitive primitive) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        PeriEllipse ellipse = (PeriEllipse)primitive;
        Point axis1Start = ellipse.getAxis1Start();
        Point axis1End = ellipse.getAxis1End();
        Line axis1Line = geometryManager.createLine(primitive.getGeometryType().getSubType());
        axis1Line.setPoints(axis1Start, axis1End);
        drawingStatus.addStatus((Geometry)axis1Line, auxiliaryLineSymbolEditing, "");
        Line axis2Line = geometryManager.createLine(primitive.getGeometryType().getSubType());
        Point center = geometryManager.createPoint((axis1Start.getX() + axis1End.getX()) / 2.0, (axis1Start.getY() + axis1End.getY()) / 2.0, primitive.getGeometryType().getSubType());
        double angle = this.getAngle(axis1Start, axis1End);
        Point axis2Point1 = geometryManager.createPoint(center.getX() + ellipse.getAxis2Dist() * Math.cos(angle + 1.5707963267948966), center.getY() + ellipse.getAxis2Dist() * Math.sin(angle + 1.5707963267948966), primitive.getGeometryType().getSubType());
        Point axis2Point2 = geometryManager.createPoint(center.getX() - ellipse.getAxis2Dist() * Math.cos(angle + 1.5707963267948966), center.getY() - ellipse.getAxis2Dist() * Math.sin(angle + 1.5707963267948966), primitive.getGeometryType().getSubType());
        axis2Line.setPoints(axis2Point1, axis2Point2);
        drawingStatus.addStatus((Geometry)axis2Line, auxiliaryLineSymbolEditing, "");
        drawingStatus.addStatus((Geometry)primitive, drawingStatus.getPreviewSymbol(), "");
        drawingStatus.addStatus((Geometry)primitive, lineSymbolEditing, "");
    }
}

