/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.editvertex.operation;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperation;
import org.gvsig.vectorediting.lib.prov.editvertex.operation.EditVertexOperationUtils;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;

public class PolygonEditVertexOperation
implements EditVertexOperation {
    @Override
    public Geometry insertVertex(Primitive geom, int index) throws CreateGeometryException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Polygon polygon = (Polygon)geom.cloneGeometry();
        int numVertices = polygon.getNumVertices();
        if (index < 0) {
            return polygon;
        }
        if (index >= numVertices && geom instanceof Surface) {
            Surface sgeom = (Surface)geom.cloneGeometry();
            int count = 0;
            int dif = index - sgeom.getNumVertices();
            for (int i = 0; i < sgeom.getNumInteriorRings(); ++i) {
                Ring ring = sgeom.getInteriorRing(i);
                if (count + ring.getNumVertices() > dif) {
                    int positionIndexRing = dif - count;
                    numVertices = ring.getNumVertices();
                    int indexToInsert = positionIndexRing;
                    Point antVertex = ring.getVertex(numVertices - 1);
                    if (positionIndexRing == 0 && ring.getVertex(0).equals(antVertex)) {
                        indexToInsert = numVertices - 1;
                    }
                    if (indexToInsert != 0) {
                        antVertex = ring.getVertex(indexToInsert - 1);
                    }
                    Point point = ring.getVertex(indexToInsert);
                    GeometryType geomType = ring.getGeometryType();
                    Point newPoint = geometryManager.createPoint((point.getX() + antVertex.getX()) / 2.0, (point.getY() + antVertex.getY()) / 2.0, geomType.getSubType());
                    for (int ri = 2; ri < ring.getDimension(); ++ri) {
                        newPoint.setCoordinateAt(ri, (point.getCoordinateAt(ri) + antVertex.getCoordinateAt(ri)) / 2.0);
                    }
                    ring.insertVertex(indexToInsert, newPoint);
                    return sgeom;
                }
                count += ring.getNumVertices();
            }
        }
        int indexToInsert = index;
        Point antVertex = polygon.getVertex(numVertices - 1);
        if (index == 0 && polygon.getVertex(0).equals(antVertex)) {
            indexToInsert = numVertices - 1;
        }
        if (indexToInsert != 0) {
            antVertex = polygon.getVertex(indexToInsert - 1);
        }
        Point point = polygon.getVertex(indexToInsert);
        GeometryType geomType = geom.getGeometryType();
        Point newPoint = geometryManager.createPoint((point.getX() + antVertex.getX()) / 2.0, (point.getY() + antVertex.getY()) / 2.0, geomType.getSubType());
        for (int i = 2; i < geom.getDimension(); ++i) {
            newPoint.setCoordinateAt(i, (point.getCoordinateAt(i) + antVertex.getCoordinateAt(i)) / 2.0);
        }
        polygon.insertVertex(indexToInsert, newPoint);
        return polygon;
    }

    @Override
    public Geometry removeVertex(Primitive geom, int index) throws CreateGeometryException {
        Polygon polygon = (Polygon)geom.cloneGeometry();
        int numVertices = polygon.getNumVertices();
        if (index < 0) {
            return polygon;
        }
        if (index >= numVertices && geom instanceof Surface) {
            Surface sgeom = (Surface)geom.cloneGeometry();
            int count = 0;
            int dif = index - sgeom.getNumVertices();
            for (int i = 0; i < sgeom.getNumInteriorRings(); ++i) {
                Ring ring = sgeom.getInteriorRing(i);
                if (count + ring.getNumVertices() > dif) {
                    if (ring.getNumVertices() <= 4) {
                        sgeom.removeInteriorRing(i);
                        return sgeom;
                    }
                    int positionIndexRing = dif - count;
                    ring.removeVertex(positionIndexRing);
                    if (count == dif) {
                        ring.removeVertex(ring.getNumVertices() - 1);
                    } else if (count + ring.getNumVertices() == dif) {
                        ring.removeVertex(0);
                    }
                    return sgeom;
                }
                count += ring.getNumVertices();
            }
        }
        if (polygon.getVertex(0).equals(polygon.getVertex(numVertices - 1))) {
            if (numVertices <= 4) {
                return polygon;
            }
            if (index == 0 || index == numVertices - 1) {
                polygon.removeVertex(numVertices - 1);
                polygon.removeVertex(0);
                polygon.addVertex(polygon.getVertex(0));
                --numVertices;
                return polygon;
            }
            --numVertices;
        } else if (numVertices <= 3) {
            return polygon;
        }
        polygon.removeVertex(index);
        return polygon;
    }

    @Override
    public Geometry moveVertex(Primitive geom, int index, Point point) {
        Polygon result = (Polygon)geom.cloneGeometry();
        int numVertices = result.getNumVertices();
        if (index < result.getNumVertices()) {
            if (result.getVertex(0).equals(result.getVertex(numVertices - 1)) && (index == 0 || index == result.getNumVertices() - 1)) {
                EditVertexOperationUtils.setVertex((OrientablePrimitive)result, 0, point);
                EditVertexOperationUtils.setVertex((OrientablePrimitive)result, result.getNumVertices() - 1, point.cloneGeometry());
                return result;
            }
            EditVertexOperationUtils.setVertex((OrientablePrimitive)result, index, point);
            return result;
        }
        if (geom instanceof Surface) {
            Surface sgeom = (Surface)geom;
            int count = 0;
            int dif = index - sgeom.getNumVertices();
            for (int i = 0; i < sgeom.getNumInteriorRings(); ++i) {
                Ring ring = sgeom.getInteriorRing(i);
                if (count + ring.getNumVertices() > dif) {
                    EditVertexOperationUtils.setVertex((OrientablePrimitive)sgeom, index, point);
                    int positionIndexRing = sgeom.getNumVertices() + count;
                    if (count == dif) {
                        EditVertexOperationUtils.setVertex((OrientablePrimitive)sgeom, positionIndexRing + ring.getNumVertices() - 1, point.cloneGeometry());
                    } else if (count + ring.getNumVertices() == dif) {
                        EditVertexOperationUtils.setVertex((OrientablePrimitive)sgeom, positionIndexRing - ring.getNumVertices() - 1, point.cloneGeometry());
                    }
                    return sgeom;
                }
                count += ring.getNumVertices();
            }
        }
        return result;
    }

    @Override
    public List<Point> getVertexesList(Primitive geom) {
        ArrayList<Point> vertexList = new ArrayList<Point>();
        if (geom instanceof OrientablePrimitive) {
            Surface surface;
            OrientablePrimitive orientable = (OrientablePrimitive)geom;
            orientable.getNumVertices();
            for (int i = 0; i < orientable.getNumVertices(); ++i) {
                vertexList.add(orientable.getVertex(i));
            }
            if (geom instanceof Surface && (surface = (Surface)geom).getNumInteriorRings() > 0) {
                for (int i = 0; i < surface.getNumInteriorRings(); ++i) {
                    Ring iRing = surface.getInteriorRing(i);
                    for (int ri = 0; ri < iRing.getNumVertices(); ++ri) {
                        vertexList.add(iRing.getVertex(ri));
                    }
                }
            }
        }
        return vertexList;
    }

    @Override
    public int getNumVertex(Primitive geom) {
        if (geom instanceof OrientablePrimitive) {
            Surface surface;
            OrientablePrimitive orientable = (OrientablePrimitive)geom;
            int totalVertices = orientable.getNumVertices();
            if (geom instanceof Surface && (surface = (Surface)geom).getNumInteriorRings() > 0) {
                for (int i = 0; i < surface.getNumInteriorRings(); ++i) {
                    Ring iRing = surface.getInteriorRing(i);
                    totalVertices += iRing.getNumVertices();
                }
            }
            return totalVertices;
        }
        return 0;
    }

    @Override
    public boolean canInsertVertex(Primitive geom, int index) {
        return true;
    }

    @Override
    public boolean canRemoveVertex(Primitive geom, int index) {
        Polygon polygon = (Polygon)geom;
        int numVertices = polygon.getNumVertices();
        if (index < 0) {
            return false;
        }
        if (index >= numVertices) {
            return true;
        }
        return !(polygon.getVertex(0).equals(polygon.getVertex(numVertices - 1)) ? numVertices <= 4 : numVertices <= 3);
    }

    @Override
    public boolean canMoveVertex(int index, Point point) {
        return true;
    }

    @Override
    public void addToDrawingStatus(DefaultDrawingStatus drawingStatus, Primitive primitive) {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        drawingStatus.addStatus((Geometry)primitive, drawingStatus.getPreviewSymbol(), "");
        drawingStatus.addStatus((Geometry)primitive, polygonSymbolEditing, "");
    }
}

