/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.accCost;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.ArrayList;

public class AccCostAlgorithm
extends GeoAlgorithm {
    public static final String COST = "COST";
    public static final String FEATURES = "FEATURES";
    public static final String ACCCOST = "ACCCOST";
    public static final String CLOSESTPOINT = "CLOSESTPOINT";
    public static final String DISTANCE = "DISTANCE";
    private static final int NO_DATA = -1;
    public static final int EUCLIDEAN = 0;
    public static final int CHESSBOARD = 1;
    public static final int MANHATTAN = 2;
    public static final int CHAMFER = 3;
    public static final int WINDOW5X5 = 4;
    private int m_iNX;
    private int m_iNY;
    private int m_iDistance;
    private IRasterLayer m_Cost;
    private IRasterLayer m_Features;
    private IRasterLayer m_AccCost;
    private IRasterLayer m_ClosestPoint;
    private ArrayList m_CentralPoints;
    private ArrayList m_AdjPoints;

    public void defineCharacteristics() {
        String[] sOptions = new String[]{Sextante.getText((String)"Euclidean"), Sextante.getText((String)"Chessboard"), Sextante.getText((String)"Manhattan"), Sextante.getText((String)"Chamfer_3-4"), " 5 X 5"};
        this.setName(Sextante.getText((String)"Accumulated_cost__isotropic"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(COST, Sextante.getText((String)"Unitary_cost"), true);
            this.m_Parameters.addInputRasterLayer(FEATURES, Sextante.getText((String)"Origin-destination_points"), true);
            this.addOutputRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"));
            this.addOutputRasterLayer(CLOSESTPOINT, Sextante.getText((String)"Closest_points"));
            this.m_Parameters.addSelection(DISTANCE, Sextante.getText((String)"Type_of_distance"), sOptions);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iPoint = 1;
        this.m_CentralPoints = new ArrayList();
        this.m_AdjPoints = new ArrayList();
        this.m_Cost = this.m_Parameters.getParameterValueAsRasterLayer(COST);
        this.m_Features = this.m_Parameters.getParameterValueAsRasterLayer(FEATURES);
        this.m_iDistance = this.m_Parameters.getParameterValueAsInt(DISTANCE);
        this.m_AccCost = this.getNewRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"), 5);
        this.m_ClosestPoint = this.getNewRasterLayer(CLOSESTPOINT, Sextante.getText((String)"Closest_points"), 3);
        AnalysisExtent extent = this.m_AccCost.getWindowGridExtent();
        this.m_Cost.setWindowExtent(extent);
        this.m_Cost.setInterpolationMethod(4);
        this.m_Features.setWindowExtent(extent);
        this.m_Features.setInterpolationMethod(0);
        this.m_iNX = this.m_Cost.getNX();
        this.m_iNY = this.m_Cost.getNY();
        this.m_AccCost.setNoDataValue(-1.0);
        this.m_AccCost.assignNoData();
        this.m_ClosestPoint.setNoDataValue(-1.0);
        this.m_ClosestPoint.assignNoData();
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Features.getCellValueAsDouble(x, y);
                if (dValue == 0.0 || this.m_Features.isNoDataValue(dValue)) continue;
                this.m_CentralPoints.add(new GridCell(x, y, (double)iPoint));
                this.m_AccCost.setCellValue(x, y, 0.0);
                this.m_ClosestPoint.setCellValue(x, y, (double)iPoint);
                ++iPoint;
            }
        }
        if (this.m_iDistance != 4) {
            this.calculateCost3X3();
        } else {
            this.calculateCost5X5();
        }
        return !this.m_Task.isCanceled();
    }

    private void calculateCost5X5() {
        int j;
        int i;
        double[][] dDist = new double[5][5];
        for (i = -2; i < 3; ++i) {
            for (j = -1; j < 2; ++j) {
                dDist[i + 2][j + 2] = Math.sqrt(i * i + j * j);
            }
        }
        while (this.m_CentralPoints.size() != 0 && !this.m_Task.isCanceled()) {
            for (int iPt = 0; iPt < this.m_CentralPoints.size(); ++iPt) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                int iPoint = (int)cell.getValue();
                for (i = -2; i < 3; ++i) {
                    for (j = -2; j < 3; ++j) {
                        int x2 = x + i;
                        int y2 = y + j;
                        double dCost = this.getCostTo(x, y, i, j);
                        if (dCost == -1.0) continue;
                        double dAccCost = this.m_AccCost.getCellValueAsDouble(x, y);
                        dAccCost += dCost * dDist[i + 2][j + 2];
                        double dPrevAccCost = this.m_AccCost.getCellValueAsDouble(x2, y2);
                        if (!this.m_AccCost.isNoDataValue(dPrevAccCost) && !(dPrevAccCost > dAccCost)) continue;
                        this.m_AccCost.setCellValue(x2, y2, dAccCost);
                        this.m_ClosestPoint.setCellValue(x2, y2, (double)iPoint);
                        this.m_AdjPoints.add(new GridCell(x2, y2, (double)iPoint));
                    }
                }
            }
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
        }
    }

    private double getCostTo(int x, int y, int i, int j) {
        int nMax;
        double di;
        double dj;
        int iCells = 0;
        double dCost = 0.0;
        if (i == 0 && j == 0) {
            return 0.0;
        }
        if (i > j) {
            dj = Math.abs((double)j / (double)i) * (double)Math.signum(j);
            di = Math.signum(i);
            nMax = Math.abs(i);
        } else {
            di = Math.abs((double)i / (double)j) * (double)Math.signum(i);
            dj = Math.signum(j);
            nMax = Math.abs(j);
        }
        double ii = 0.0;
        double jj = 0.0;
        int n = 0;
        while (n <= nMax) {
            double dPartialCost = this.m_Cost.getCellValueAsDouble((int)((double)x + ii), (int)((double)y + jj));
            if (this.m_Cost.isNoDataValue(dPartialCost) || dPartialCost <= 0.0) {
                return -1.0;
            }
            dCost += dPartialCost;
            ++iCells;
            ++n;
            ii += di;
            jj += dj;
        }
        return dCost / (double)iCells;
    }

    private void calculateCost3X3() {
        int j;
        int i;
        Object dDist = new double[3][3];
        switch (this.m_iDistance) {
            default: {
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        dDist[i + 1][j + 1] = Math.sqrt(i * i + j * j);
                    }
                }
                break;
            }
            case 1: {
                double[][] chessboard = new double[][]{{1.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 1.0}};
                dDist = chessboard;
                break;
            }
            case 2: {
                double[][] manhattan = new double[][]{{2.0, 1.0, 2.0}, {1.0, 0.0, 1.0}, {2.0, 1.0, 2.0}};
                dDist = manhattan;
                break;
            }
            case 3: {
                double[][] chamfer = new double[][]{{4.0, 3.0, 4.0}, {3.0, 0.0, 3.0}, {4.0, 3.0, 4.0}};
                dDist = chamfer;
            }
        }
        while (this.m_CentralPoints.size() != 0 && !this.m_Task.isCanceled()) {
            for (int iPt = 0; iPt < this.m_CentralPoints.size(); ++iPt) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                int iPoint = (int)cell.getValue();
                double dCost1 = this.m_Cost.getCellValueAsDouble(x, y);
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        int x2 = x + i;
                        int y2 = y + j;
                        double dCost2 = this.m_Cost.getCellValueAsDouble(x2, y2);
                        if (this.m_Cost.isNoDataValue(dCost1) || this.m_Cost.isNoDataValue(dCost2) || !(dCost1 > 0.0) || !(dCost2 > 0.0)) continue;
                        double dAccCost = this.m_AccCost.getCellValueAsDouble(x, y);
                        dAccCost += (dCost1 + dCost2) / 2.0 * dDist[i + 1][j + 1];
                        double dPrevAccCost = this.m_AccCost.getCellValueAsDouble(x2, y2);
                        if (!this.m_AccCost.isNoDataValue(dPrevAccCost) && !(dPrevAccCost > dAccCost)) continue;
                        this.m_AccCost.setCellValue(x2, y2, dAccCost);
                        this.m_ClosestPoint.setCellValue(x2, y2, (double)iPoint);
                        this.m_AdjPoints.add(new GridCell(x2, y2, (double)iPoint));
                    }
                }
            }
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
            this.setProgressText(Integer.toString(this.m_CentralPoints.size()));
        }
    }
}

