/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.roc;

import com.vividsolutions.jts.geom.Coordinate;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ROCAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String POINTS = "POINTS";
    public static final String GRAPH = "GRAPH";
    public static final String FIELD = "FIELD";
    public static final String AREA = "AREA";
    private IVectorLayer m_Points;
    private IRasterLayer m_Suitability;
    private XYSeries serie;
    private boolean[] bPresence;
    private int m_iField;
    private final double m_dLastSensitivity = 0.0;
    private final double m_dLastEspecificity = 0.0;
    private double m_dArea;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"ROC_curve"));
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Suitability"), true);
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Observed_points"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Presence-abscence_field"), POINTS);
            this.addOutputChart(GRAPH, Sextante.getText((String)"ROC"));
            this.addOutputText(AREA, Sextante.getText((String)"ROC_curve"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_dArea = 0.0;
        this.m_Suitability = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        this.m_Suitability.setFullExtent();
        XYSeriesCollection dataset = new XYSeriesCollection();
        this.serie = new XYSeries((Comparable)((Object)Sextante.getText((String)"Profile")));
        dataset.addSeries(this.serie);
        this.createPointsData();
        this.calculateCurveData();
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel jPanelChart = new ChartPanel(chart);
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.addOutputChart(GRAPH, Sextante.getText((String)"ROC"), jPanelChart);
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"ROC_curve"));
        doc.addHeader(Sextante.getText((String)"ROC_curve"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"area_under_the_curve") + ":" + Double.toString(this.m_dArea));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(AREA, Sextante.getText((String)"ROC_curve"), doc.getHTMLCode());
        return !this.m_Task.isCanceled();
    }

    private void createPointsData() {
        int iPoints = this.m_Points.getShapesCount();
        this.bPresence = new boolean[iPoints];
        int i = 0;
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext()) {
            try {
                IFeature feature = iter.next();
                Object[] record = feature.getRecord().getValues();
                String sValue = record[this.m_iField].toString();
                double dValue = Double.parseDouble(sValue);
                this.bPresence[i] = dValue != 0.0;
            }
            catch (Exception e) {
                this.bPresence[i] = false;
            }
            ++i;
        }
        iter.close();
    }

    private void calculateCurveData() throws IteratorException {
        for (int i = 0; i < 100 && this.setProgress(i, 100); ++i) {
            double dCutoff = (double)i / 100.0;
            int iFalsePositives = 0;
            int iTruePositives = 0;
            int iFalseNegatives = 0;
            int iTrueNegatives = 0;
            int j = 0;
            IFeatureIterator iter = this.m_Points.iterator();
            while (iter.hasNext()) {
                IFeature feature = iter.next();
                Coordinate pt = feature.getGeometry().getCoordinate();
                double dValue = this.m_Suitability.getValueAt(pt.x, pt.y);
                if (!this.m_Suitability.isNoDataValue(dValue)) {
                    if (dValue < dCutoff) {
                        if (this.bPresence[j]) {
                            ++iTruePositives;
                        } else {
                            ++iFalsePositives;
                        }
                    } else if (this.bPresence[j]) {
                        ++iFalseNegatives;
                    } else {
                        ++iTrueNegatives;
                    }
                }
                ++j;
            }
            iter.close();
            double dSensitivity = (double)iTruePositives / (double)(iTruePositives + iFalseNegatives);
            double dEspecificity = (double)iFalsePositives / (double)(iFalsePositives + iTrueNegatives);
            if (Double.isNaN(dSensitivity) || Double.isNaN(dEspecificity)) continue;
            this.serie.add(dSensitivity, dEspecificity);
            this.m_dArea += (dEspecificity + 0.0) / 2.0 * (dSensitivity - 0.0);
        }
    }
}

