/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.generateRandomUniform;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class GenerateRandomUniformAlgorithm
extends GeoAlgorithm {
    public static final String PROB = "PROB";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    private IRasterLayer m_Result;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dMin = this.m_Parameters.getParameterValueAsDouble(MIN);
        double dMax = this.m_Parameters.getParameterValueAsDouble(MAX);
        this.m_Result = this.getNewRasterLayer(PROB, Sextante.getText((String)"New_layer"), 4);
        int iNX = this.m_Result.getWindowGridExtent().getNX();
        int iNY = this.m_Result.getWindowGridExtent().getNY();
        for (int y = 0; y < iNY; ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = Math.random() * (dMax - dMin) + dMin;
                this.m_Result.setCellValue(x, y, dValue);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Random_grid__uniform"));
        this.setGroup(Sextante.getText((String)"Raster_creation_tools"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addNumericalValue(MIN, Sextante.getText((String)"Min_value"), 0.0, 2);
            this.m_Parameters.addNumericalValue(MAX, Sextante.getText((String)"Max_value"), 1.0, 2);
            this.addOutputRasterLayer(PROB, Sextante.getText((String)"Probability"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

