/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.gridFromFunction;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.nfunk.jep.JEP;

public class GridFromFunctionAlgorithm
extends GeoAlgorithm {
    public static final String MINX = "MINX";
    public static final String MINY = "MINY";
    public static final String MAXX = "MAXX";
    public static final String MAXY = "MAXY";
    public static final String FORMULA = "FORMULA";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        JEP jep = new JEP();
        jep.addStandardConstants();
        jep.addStandardFunctions();
        jep.addVariable("x", 0.0);
        jep.addVariable("y", 0.0);
        double dMinX = this.m_Parameters.getParameterValueAsInt(MINX);
        double dMinY = this.m_Parameters.getParameterValueAsInt(MINY);
        double dMaxX = this.m_Parameters.getParameterValueAsInt(MAXX);
        double dMaxY = this.m_Parameters.getParameterValueAsInt(MAXY);
        String sFormula = this.m_Parameters.getParameterValueAsString(FORMULA).toLowerCase();
        double dRangeX = dMaxX - dMinX;
        double dRangeY = dMaxY - dMinY;
        IRasterLayer result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Layer_from_function"), 5);
        int iNX = result.getWindowGridExtent().getNX();
        int iNY = result.getWindowGridExtent().getNY();
        jep.parseExpression(sFormula);
        if (!jep.hasError()) {
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                double dy = dMinY + dRangeY * ((double)y / (double)iNY);
                jep.addVariable("y", dy);
                for (int x = 0; x < iNX; ++x) {
                    double dx = dMinX + dRangeX * ((double)x / (double)iNX);
                    jep.addVariable("x", dx);
                    double dValue = jep.getValue();
                    result.setCellValue(x, y, dValue);
                }
            }
        } else {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Wrong_formula"));
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Grid_from_function"));
        this.setGroup(Sextante.getText((String)"Raster_creation_tools"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addNumericalValue(MINX, "X min", -1.0, 2);
            this.m_Parameters.addNumericalValue(MAXX, "X Max", 1.0, 2);
            this.m_Parameters.addNumericalValue(MINY, "Y Min", -1.0, 2);
            this.m_Parameters.addNumericalValue(MAXY, "Y Max", 1.0, 2);
            this.m_Parameters.addString(FORMULA, Sextante.getText((String)"Formula"));
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Grid_from_function"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

