/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.fragstatsArea;

import es.unex.sextante.gridCategorical.fragstatsArea.PatchInfo;
import es.unex.sextante.math.simpleStats.SimpleStats;

public class ClassInfo {
    private double m_dArea = 0.0;
    private int m_iAreaInCells = 0;
    private double m_dPerimeter = 0.0;
    private int m_iPerimeterInCells = 0;
    private double m_dLargestPatchArea = 0.0;
    private double m_dTotalLandscapeArea = 0.0;
    private int m_iPatches = 0;
    private final SimpleStats m_Area = new SimpleStats();
    private final SimpleStats m_RadiusOfGyration = new SimpleStats();

    public void setTotalLandscapeArea(double dArea) {
        this.m_dTotalLandscapeArea = dArea;
    }

    public void add(PatchInfo info) {
        ++this.m_iPatches;
        this.m_dArea += info.getArea();
        this.m_iAreaInCells += info.getAreaInCells();
        this.m_dPerimeter += info.getPerimeter();
        this.m_iPerimeterInCells += info.getPerimeterInCells();
        this.m_dLargestPatchArea = Math.max(this.m_dLargestPatchArea, info.getArea());
        this.m_Area.addValue(info.getArea());
        this.m_RadiusOfGyration.addValue(info.getRadiusOfGyration());
    }

    public double getTotalArea() {
        return this.m_dArea;
    }

    public double getPercentageOfLandscape() {
        return this.m_dArea / this.m_dTotalLandscapeArea * 100.0;
    }

    public int getPatchesCount() {
        return this.m_iPatches;
    }

    public double getPatchDensity() {
        return (double)this.m_iPatches * 10000.0 / this.m_dTotalLandscapeArea * 100.0;
    }

    public double getTotalEdge() {
        return this.m_dPerimeter;
    }

    public double getEdgeDensity() {
        return this.m_dPerimeter * 10000.0 / this.m_dTotalLandscapeArea;
    }

    public double getLandscapeShapeIndex() {
        int n = (int)Math.floor(Math.sqrt(this.m_dArea));
        double m = this.m_dArea - (double)(n * n);
        int min = m == 0.0 ? 4 * n : (this.m_dArea > (double)(n * (n + 1)) ? 4 * n + 4 : 4 * n + 2);
        return (double)this.m_iPerimeterInCells / (double)min;
    }

    public double getLargestPatchIndex() {
        return this.m_dLargestPatchArea / this.m_dTotalLandscapeArea * 100.0;
    }

    public SimpleStats getPatchAreaDistribution() {
        return this.m_Area;
    }

    public SimpleStats getRadiusOfGyrationDistribution() {
        return this.m_RadiusOfGyration;
    }
}

