/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.fragstatsArea;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gridCategorical.fragstatsArea.ClassInfo;
import es.unex.sextante.gridCategorical.fragstatsArea.PatchInfo;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class FragstatsAreaAlgorithm
extends GeoAlgorithm {
    public static final String METRICS = "METRICS";
    public static final String INPUT = "INPUT";
    private final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Grid;
    private IRasterLayer m_Visited;
    private ArrayList m_Patches;
    private HashMap m_Classes;
    private ClassInfo m_Landscape;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Fragstats__area-density-edge_metrics"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputText(METRICS, Sextante.getText((String)"Metrics"), null);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Grid.setFullExtent();
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        this.m_Patches = new ArrayList();
        this.m_Classes = new HashMap();
        this.m_Landscape = new ClassInfo();
        this.m_Visited = this.getTempRasterLayer(0, this.m_Grid.getWindowGridExtent());
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                PatchInfo patchInfo;
                byte value = this.m_Visited.getCellValueAsByte(x, y);
                if (value != 0 || (patchInfo = this.analysePatch(x, y)) == null) continue;
                this.m_Patches.add(patchInfo);
                Integer ClassID = new Integer(patchInfo.getClassID());
                ClassInfo classInfo = (ClassInfo)this.m_Classes.get(ClassID);
                if (classInfo == null) {
                    classInfo = new ClassInfo();
                    classInfo.add(patchInfo);
                    this.m_Classes.put(ClassID, classInfo);
                } else {
                    classInfo.add(patchInfo);
                }
                this.m_Landscape.add(patchInfo);
            }
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.createOutput();
        return true;
    }

    private void createOutput() {
        HTMLDoc doc = new HTMLDoc();
        DecimalFormat df = new DecimalFormat("##.##");
        String[][] sTable = new String[this.m_Patches.size() + 1][4];
        doc.open(Sextante.getText((String)"area-density-edge_metrics"));
        doc.addHeader(Sextante.getText((String)"area-density-edge_metrics"), 1);
        doc.addHeader(Sextante.getText((String)"Patch_metrics"), 2);
        sTable[0][0] = Sextante.getText((String)"Class");
        sTable[0][1] = Sextante.getText((String)"Area");
        sTable[0][2] = Sextante.getText((String)"Perimeter");
        sTable[0][3] = Sextante.getText((String)"Radius_of_gyration");
        for (int i = 0; i < this.m_Patches.size(); ++i) {
            PatchInfo patchInfo = (PatchInfo)this.m_Patches.get(i);
            sTable[i + 1][0] = Integer.toString(i);
            sTable[i + 1][1] = df.format(patchInfo.getArea());
            sTable[i + 1][2] = df.format(patchInfo.getPerimeter());
            sTable[i + 1][3] = df.format(patchInfo.getRadiusOfGyration());
        }
        doc.addTable(sTable, "", true, true);
        doc.addHeader(Sextante.getText((String)"Class_metrics"), 2);
        Set set = this.m_Classes.keySet();
        Iterator iter = set.iterator();
        sTable = new String[this.m_Classes.size() + 1][9];
        int iRow = 1;
        sTable[0][0] = Sextante.getText((String)"Class");
        sTable[0][1] = Sextante.getText((String)"total_area_Total");
        sTable[0][2] = Sextante.getText((String)"Percentage_of_Landscape");
        sTable[0][3] = Sextante.getText((String)"Number_of_patches");
        sTable[0][4] = Sextante.getText((String)"Patch_Density");
        sTable[0][5] = Sextante.getText((String)"Total_perimeter");
        sTable[0][6] = Sextante.getText((String)"Edge_Density");
        sTable[0][7] = Sextante.getText((String)"Landscape_shape_index");
        sTable[0][8] = Sextante.getText((String)"Largest_patch_index");
        while (iter.hasNext()) {
            Integer Class2 = (Integer)iter.next();
            ClassInfo classInfo = (ClassInfo)this.m_Classes.get(Class2);
            classInfo.setTotalLandscapeArea(this.m_Landscape.getTotalArea());
            sTable[iRow][0] = Integer.toString(Class2);
            sTable[iRow][1] = df.format(classInfo.getTotalArea());
            sTable[iRow][2] = df.format(classInfo.getPercentageOfLandscape());
            sTable[iRow][3] = df.format(classInfo.getPatchesCount());
            sTable[iRow][4] = df.format(classInfo.getPatchDensity());
            sTable[iRow][5] = df.format(classInfo.getTotalEdge());
            sTable[iRow][6] = df.format(classInfo.getEdgeDensity());
            sTable[iRow][7] = df.format(classInfo.getLandscapeShapeIndex());
            sTable[iRow][8] = df.format(classInfo.getLargestPatchIndex());
            ++iRow;
        }
        doc.addTable(sTable, "", true, true);
        this.m_Landscape.setTotalLandscapeArea(this.m_Landscape.getTotalArea());
        doc.addHeader(Sextante.getText((String)"Landscape_metrics"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Total_area") + ": " + df.format(this.m_Landscape.getTotalArea()));
        doc.addListElement(Sextante.getText((String)"Number_of_patches") + ": " + df.format(this.m_Landscape.getPatchesCount()));
        doc.addListElement(Sextante.getText((String)"Patch_Density") + ": " + df.format(this.m_Landscape.getPatchDensity()));
        doc.addListElement(Sextante.getText((String)"Total_perimeter") + ": " + df.format(this.m_Landscape.getTotalEdge()));
        doc.addListElement(Sextante.getText((String)"Edge_Density") + ": " + df.format(this.m_Landscape.getEdgeDensity()));
        doc.addListElement(Sextante.getText((String)"Landscape_shape_index") + ": " + df.format(this.m_Landscape.getLandscapeShapeIndex()));
        doc.addListElement(Sextante.getText((String)"Largest_patch_index") + ": " + df.format(this.m_Landscape.getLargestPatchIndex()));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(METRICS, Sextante.getText((String)"Metrics") + "[" + this.m_Grid.getName() + "]", doc.getHTMLCode());
    }

    private PatchInfo analysePatch(int x, int y) {
        boolean iVisitedValue = true;
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        int iInitClass = this.m_Grid.getCellValueAsInt(x, y);
        if (this.m_Grid.isNoDataValue((double)iInitClass)) {
            return null;
        }
        int iInitX = x;
        int iInitY = y;
        PatchInfo info = new PatchInfo(iInitClass, this.m_Grid);
        centralPoints.add(new Point(x, y));
        info.add(x, y);
        this.m_Visited.setCellValue(x, y, 1.0);
        for (byte i = 0; i < 2; ++i) {
            while (centralPoints.size() != 0) {
                for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                    Point point = (Point)centralPoints.get(iPt);
                    x = point.x;
                    y = point.y;
                    int iClass = this.m_Grid.getCellValueAsInt(x, y);
                    if (this.m_Grid.isNoDataValue((double)iClass)) continue;
                    for (int n = 0; n < 8; ++n) {
                        byte visited;
                        int x2 = x + this.m_iOffsetX[n];
                        int y2 = y + this.m_iOffsetY[n];
                        iClass = this.m_Grid.getCellValueAsInt(x2, y2);
                        if (this.m_Grid.isNoDataValue((double)iClass) || (visited = this.m_Visited.getCellValueAsByte(x2, y2)) != i || iInitClass != iClass) continue;
                        this.m_Visited.setCellValue(x2, y2, (double)(i + 1));
                        info.addForRadiusOfGyration(x2, y2);
                        adjPoints.add(new Point(x2, y2));
                    }
                }
                centralPoints = adjPoints;
                adjPoints = new ArrayList();
            }
            centralPoints.clear();
            centralPoints.add(new Point(iInitX, iInitY));
            info.addForRadiusOfGyration(iInitX, iInitX);
            if (i != 0) continue;
            info.calculateCentroid();
        }
        return info;
    }
}

