/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.fragstatsDiversity;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gridCategorical.fragstatsDiversity.ClassInfo;
import es.unex.sextante.gridCategorical.fragstatsDiversity.PatchInfo;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class FragstatsDiversityAlgorithm
extends GeoAlgorithm {
    public static final String METRICS = "METRICS";
    public static final String INPUT = "INPUT";
    public static final String MAX = "MAX";
    private final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private int m_iNX;
    private int m_iNY;
    private int m_iMax;
    private double m_dLandscapeArea;
    private IRasterLayer m_Grid;
    private IRasterLayer m_Visited;
    private ArrayList m_Patches;
    private HashMap m_Classes;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Fragstats__diversity_metrics"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(MAX, Sextante.getText((String)"Maximum_number_of_different_classes"), 1, 10.0, 0.0, 2.147483647E9);
            this.addOutputText(METRICS, Sextante.getText((String)"Metrics"), null);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_iMax = this.m_Parameters.getParameterValueAsInt(MAX);
        this.m_Grid.setFullExtent();
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        this.m_Patches = new ArrayList();
        this.m_Classes = new HashMap();
        this.m_Visited = this.getTempRasterLayer(0, this.m_Grid.getWindowGridExtent());
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                PatchInfo patchInfo;
                byte value = this.m_Visited.getCellValueAsByte(x, y);
                if (value != 0 || (patchInfo = this.analysePatch(x, y)) == null) continue;
                this.m_Patches.add(patchInfo);
                Integer ClassID = new Integer(patchInfo.getClassID());
                ClassInfo classInfo = (ClassInfo)this.m_Classes.get(ClassID);
                if (classInfo == null) {
                    classInfo = new ClassInfo();
                    classInfo.add(patchInfo);
                    this.m_Classes.put(ClassID, classInfo);
                } else {
                    classInfo.add(patchInfo);
                }
                this.m_dLandscapeArea += patchInfo.getArea();
            }
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        this.createOutput();
        return true;
    }

    private void createOutput() {
        HTMLDoc doc = new HTMLDoc();
        DecimalFormat df = new DecimalFormat("##.##");
        double dShannon = 0.0;
        double dSimpson = 0.0;
        double dSimpsonMod = 0.0;
        Set set = this.m_Classes.keySet();
        for (Integer Class2 : set) {
            ClassInfo classInfo = (ClassInfo)this.m_Classes.get(Class2);
            classInfo.setTotalLandscapeArea(this.m_dLandscapeArea);
            double dPercentage = classInfo.getPercentageOfLandscape();
            dShannon -= dPercentage * Math.log(dPercentage);
            dSimpson += dPercentage * dPercentage;
        }
        dSimpsonMod = -Math.log(dSimpson);
        dSimpson = 1.0 - dSimpson;
        double dShannonEvenness = dShannon / Math.log(this.m_iMax);
        double dSimpsonEvenness = dSimpson / (1.0 - 1.0 / (double)this.m_iMax);
        double dSimpsonEvennessMod = dSimpsonMod / Math.log(this.m_iMax);
        doc.open(Sextante.getText((String)"Diversity_metrics"));
        doc.addHeader(Sextante.getText((String)"Diversity_metrics"), 1);
        doc.addHeader(Sextante.getText((String)"Landscape_metrics"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Richness") + ": " + Integer.toString(this.m_Classes.size()));
        doc.addListElement(Sextante.getText((String)"Patch_Richness_Density") + ": " + df.format((double)this.m_Classes.size() * 10000.0 * 100.0 / this.m_dLandscapeArea));
        doc.addListElement(Sextante.getText((String)"Relative_richness") + ": " + df.format((double)this.m_Classes.size() / (double)this.m_iMax * 100.0));
        doc.addListElement(Sextante.getText((String)"Shannon_index") + ": " + df.format(dShannon));
        doc.addListElement(Sextante.getText((String)"Simpson_index") + ": " + df.format(dSimpson));
        doc.addListElement(Sextante.getText((String)"Modified_Simpson_index") + ": " + df.format(dSimpsonMod));
        doc.addListElement(Sextante.getText((String)"Shannon_uniformity_index") + ": " + df.format(dShannonEvenness));
        doc.addListElement(Sextante.getText((String)"Simpson_uniformity_index") + ": " + df.format(dSimpsonEvenness));
        doc.addListElement(Sextante.getText((String)"Modified_Simpson_uniformity_index") + ": " + df.format(dSimpsonEvennessMod));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(METRICS, Sextante.getText((String)"Metrics") + "[" + this.m_Grid.getName() + "]", doc.getHTMLCode());
    }

    private PatchInfo analysePatch(int x, int y) {
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        int iInitClass = this.m_Grid.getCellValueAsInt(x, y);
        if (this.m_Grid.isNoDataValue((double)iInitClass)) {
            return null;
        }
        centralPoints.add(new Point(x, y));
        PatchInfo info = new PatchInfo(iInitClass, this.m_Grid);
        while (centralPoints.size() != 0) {
            for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                Point point = (Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                int iClass = this.m_Grid.getCellValueAsInt(x, y);
                if (this.m_Grid.isNoDataValue((double)iClass)) continue;
                for (int n = 0; n < 8; ++n) {
                    byte visited;
                    int x2 = x + this.m_iOffsetX[n];
                    int y2 = y + this.m_iOffsetY[n];
                    iClass = this.m_Grid.getCellValueAsInt(x2, y2);
                    if (this.m_Grid.isNoDataValue((double)iClass) || (visited = this.m_Visited.getCellValueAsByte(x2, y2)) == 1 || iInitClass != iClass) continue;
                    this.m_Visited.setCellValue(x2, y2, 1.0);
                    info.addCell();
                    adjPoints.add(new Point(x2, y2));
                }
            }
            centralPoints = adjPoints;
            adjPoints = new ArrayList();
        }
        return info;
    }
}

