/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.lacunarity;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LacunarityAlgorithm
extends GeoAlgorithm {
    public static final String RESULT_CHART = "RESULT_CHART";
    public static final String RESULT_TABLE = "RESULT_TABLE";
    public static final String INPUT = "INPUT";
    public static final String MAX_SIZE = "MAX_SIZE";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Window;
    private int m_iMaxSize;
    private double[] m_dLacunarity;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Lacunarity"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Input_Layer"), true);
            this.m_Parameters.addNumericalValue(MAX_SIZE, Sextante.getText((String)"Largest_window_size"), 1, 10.0, 4.0, 2.147483647E9);
            this.addOutputTable(RESULT_TABLE, Sextante.getText((String)"Lacunarity"));
            this.addOutputChart(RESULT_CHART, Sextante.getText((String)"Lacunarity"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_iMaxSize = this.m_Parameters.getParameterValueAsInt(MAX_SIZE);
        this.m_Window.setFullExtent();
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        if (this.calculateLacunarity()) {
            this.createTableAndGraph();
            return true;
        }
        return false;
    }

    private boolean calculateLacunarity() {
        this.m_dLacunarity = new double[this.m_iMaxSize + 1];
        for (int iSize = 2; iSize < this.m_dLacunarity.length; ++iSize) {
            this.setProgressText("Box size: " + Integer.toString(iSize));
            SimpleStats stats = new SimpleStats();
            for (int y = 0; y < this.m_iNY - iSize && this.setProgress(y, this.m_iNY); ++y) {
                for (int x = 0; x < this.m_iNX - iSize; ++x) {
                    int iBoxMass = this.getBoxMass(x, y, iSize);
                    stats.addValue((double)iBoxMass);
                }
            }
            this.m_dLacunarity[iSize] = 1.0 + stats.getVariance() / Math.pow(stats.getMean(), 2.0);
        }
        return !this.m_Task.isCanceled();
    }

    private int getBoxMass(int x, int y, int iSize) {
        int iBoxMass = 0;
        for (int i = 0; i < iSize; ++i) {
            for (int j = 0; j < iSize; ++j) {
                double dValue = this.m_Window.getCellValueAsDouble(x + i, y + j);
                if (this.m_Window.isNoDataValue(dValue)) continue;
                ++iBoxMass;
            }
        }
        return iBoxMass;
    }

    private void createTableAndGraph() throws UnsupportedOutputChannelException {
        String[] sFields = new String[]{Sextante.getText((String)"Window_size"), Sextante.getText((String)"Lacunaridad")};
        Class[] types = new Class[]{Integer.class, Double.class};
        String sTableName = Sextante.getText((String)"Lacunaridad") + "[" + this.m_Window.getName() + "]";
        ITable table = this.getNewTable(RESULT_TABLE, sTableName, types, sFields);
        Object[] values = new Object[2];
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries serie = new XYSeries((Comparable)((Object)Sextante.getText((String)"Profile")));
        dataset.addSeries(serie);
        for (int i = 2; i < this.m_dLacunarity.length; ++i) {
            values[0] = new Integer(i);
            values[1] = new Double(this.m_dLacunarity[i]);
            table.addRecord(values);
            serie.add((double)i, this.m_dLacunarity[i]);
        }
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel jPanelChart = new ChartPanel(chart);
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.addOutputChart(RESULT_CHART, Sextante.getText((String)"Profile"), jPanelChart);
    }
}

