/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridStatistics.neighborhoodVarianceRadius;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class NeighborhoodVarianceRadiusAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String MAXRADIUS = "MAXRADIUS";
    public static final String STDDEV = "STDDEV";
    public static final String UNITS = "UNITS";
    public static final String RESULT = "RESULT";
    public static final int UNITS_CELLS = 0;
    public static final int UNITS_MAP_UNITS = 1;
    protected double NO_DATA;
    private int m_iNX;
    private int m_iNY;
    private int m_iMaxRadius;
    private int[][] m_Check;
    private double m_dStopVariance;
    private boolean m_bWriteGridsize;
    private IRasterLayer m_Window;
    private IRasterLayer m_InputQ;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Cells"), Sextante.getText((String)"Map_units")};
        this.setUserCanDefineAnalysisExtent(false);
        this.setName(Sextante.getText((String)"Radius_of_variance"));
        this.setGroup(Sextante.getText((String)"Geostatistics"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(MAXRADIUS, Sextante.getText((String)"Maximum_radius__cells"), 1, 20.0, 2.0, 2.147483647E9);
            this.m_Parameters.addNumericalValue(STDDEV, Sextante.getText((String)"Standard_deviation"), 1.0, 2);
            this.m_Parameters.addSelection(UNITS, Sextante.getText((String)"Units"), sMethod);
            this.addOutputRasterLayer(RESULT, this.getName());
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.NO_DATA = this.m_OutputFactory.getDefaultNoDataValue();
        this.m_dStopVariance = this.m_Parameters.getParameterValueAsDouble(STDDEV);
        this.m_dStopVariance *= this.m_dStopVariance;
        this.m_iMaxRadius = this.m_Parameters.getParameterValueAsInt(MAXRADIUS);
        this.m_bWriteGridsize = this.m_Parameters.getParameterValueAsInt(UNITS) == 1;
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Window.setFullExtent();
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5, this.m_Window.getWindowGridExtent());
        this.m_InputQ = this.getTempRasterLayer(5, this.m_Window.getWindowGridExtent());
        result.setNoDataValue(this.NO_DATA);
        result.assignNoData();
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        this.initialize();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                result.setCellValue(x, y, this.getRadius(x, y));
            }
        }
        return !this.m_Task.isCanceled();
    }

    private void initialize() {
        int x;
        int y;
        for (y = 0; y < this.m_iNY; ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                double d = this.m_Window.getCellValueAsDouble(x, y);
                this.m_InputQ.setCellValue(x, y, d * d);
            }
        }
        this.m_Check = new int[this.m_iMaxRadius + 1][this.m_iMaxRadius + 1];
        for (y = 0; y <= this.m_iMaxRadius; ++y) {
            for (x = 0; x <= this.m_iMaxRadius; ++x) {
                this.m_Check[y][x] = (int)Math.sqrt(((double)x + 0.5) * ((double)x + 0.5) + ((double)y + 0.5) * ((double)y + 0.5));
            }
        }
    }

    private double getRadius(int xPoint, int yPoint) {
        double Variance;
        double sqrt2 = 1.0 / Math.sqrt(2.0);
        int Radius = 0;
        int nValues = 0;
        double Sum = 0.0;
        double SumQ = 0.0;
        do {
            int sRadius;
            if ((sRadius = (int)(sqrt2 * (double)Radius - 4.0)) < 0) {
                sRadius = 0;
            }
            for (int dy = sRadius; dy <= Radius; ++dy) {
                for (int dx = sRadius; dx <= Radius; ++dx) {
                    int x;
                    if (this.m_Check[dy][dx] != Radius) continue;
                    int y = yPoint - dy;
                    if (y >= 0) {
                        x = xPoint - dx;
                        if (x >= 0) {
                            Sum += this.m_Window.getCellValueAsDouble(x, y);
                            SumQ += this.m_InputQ.getCellValueAsDouble(x, y);
                            ++nValues;
                        }
                        if ((x = xPoint + dx) < this.m_iNX) {
                            Sum += this.m_Window.getCellValueAsDouble(x, y);
                            SumQ += this.m_InputQ.getCellValueAsDouble(x, y);
                            ++nValues;
                        }
                    }
                    if ((y = yPoint + dy) >= this.m_iNY) continue;
                    x = xPoint - dx;
                    if (x >= 0) {
                        Sum += this.m_Window.getCellValueAsDouble(x, y);
                        SumQ += this.m_InputQ.getCellValueAsDouble(x, y);
                        ++nValues;
                    }
                    if ((x = xPoint + dx) >= this.m_iNX) continue;
                    Sum += this.m_Window.getCellValueAsDouble(x, y);
                    SumQ += this.m_InputQ.getCellValueAsDouble(x, y);
                    ++nValues;
                }
            }
            if (nValues != 0) {
                double ArithMean = Sum / (double)nValues;
                Variance = SumQ / (double)nValues - ArithMean * ArithMean;
                continue;
            }
            Variance = 0.0;
        } while (Variance < this.m_dStopVariance && ++Radius <= this.m_iMaxRadius);
        return this.m_bWriteGridsize ? (double)Radius : (double)Radius * this.m_Window.getWindowCellSize();
    }
}

