/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.changeDataType;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ChangeDataTypeAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String TYPE = "TYPE";
    public static final String RESULT = "RESULT";
    public static final int BYTE = 0;
    public static final int SHORT = 0;
    public static final int INT = 0;
    public static final int FLOAT = 0;
    public static final int DOUBLE = 0;

    public void defineCharacteristics() {
        String[] sTypes = new String[]{"Byte", "Short", "Int", "Float", "Double"};
        this.setName(Sextante.getText((String)"Change_data_type"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addSelection(TYPE, Sextante.getText((String)"Data_type"), sTypes);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iRasterType;
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        int iType = this.m_Parameters.getParameterValueAsInt(TYPE);
        switch (iType) {
            case 0: {
                iRasterType = 0;
                break;
            }
            case 1: {
                iRasterType = 2;
                break;
            }
            case 2: {
                iRasterType = 3;
                break;
            }
            case 3: {
                iRasterType = 4;
                break;
            }
            default: {
                iRasterType = 5;
            }
        }
        IRasterLayer result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Result"), iRasterType);
        input.setWindowExtent(this.m_AnalysisExtent);
        int iNX = result.getWindowGridExtent().getNX();
        int iNY = result.getWindowGridExtent().getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = input.getCellValueAsDouble(x, y);
                if (!input.isNoDataValue(dValue)) {
                    result.setCellValue(x, y, dValue);
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

