/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.closeGapsNN;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.ArrayList;

public class CloseGapsNNAlgorithm
extends GeoAlgorithm {
    private static final int NO_DATA = -1;
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Window;
    IRasterLayer m_Result;
    IRasterLayer m_Filled;
    ArrayList m_CentralPoints;
    ArrayList m_AdjPoints;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Void_filling_[nearest_neighbour]"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Layer"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Filled_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_CentralPoints = new ArrayList();
        this.m_AdjPoints = new ArrayList();
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Window.setFullExtent();
        this.m_Result = this.getNewRasterLayer(RESULT, this.m_Window.getName() + Sextante.getText((String)"[filled]"), this.m_Window.getDataType(), this.m_Window.getWindowGridExtent());
        this.m_Filled = this.getTempRasterLayer(3, this.m_Window.getWindowGridExtent());
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        this.m_Filled.setNoDataValue(-1.0);
        this.m_Filled.assignNoData();
        this.m_Result.setNoDataValue(-1.0);
        this.m_Result.assignNoData();
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue)) continue;
                this.m_CentralPoints.add(new GridCell(x, y, dValue));
                this.m_Filled.setCellValue(x, y, 0.0);
                this.m_Result.setCellValue(x, y, dValue);
            }
        }
        this.closeGaps();
        return !this.m_Task.isCanceled();
    }

    private void closeGaps() {
        int j;
        int i;
        double[][] dDist = new double[3][3];
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                dDist[i + 1][j + 1] = Math.sqrt(i * i + j * j);
            }
        }
        while (this.m_CentralPoints.size() != 0 && !this.m_Task.isCanceled()) {
            for (int iPt = 0; iPt < this.m_CentralPoints.size(); ++iPt) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                double dValue = cell.getValue();
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        int x2 = x + i;
                        int y2 = y + j;
                        if (!this.m_Window.isInWindow(x2, y2)) continue;
                        double dAccCost = this.m_Filled.getCellValueAsDouble(x, y);
                        dAccCost += dDist[i + 1][j + 1];
                        double dPrevAccCost = this.m_Filled.getCellValueAsDouble(x2, y2);
                        if (!this.m_Filled.isNoDataValue(dPrevAccCost) && !(dPrevAccCost > dAccCost)) continue;
                        this.m_Filled.setCellValue(x2, y2, dAccCost);
                        this.m_Result.setCellValue(x2, y2, dValue);
                        this.m_AdjPoints.add(new GridCell(x2, y2, dValue));
                    }
                }
            }
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
    }
}

