/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.combineMasks;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class CombineMasksAlgorithm
extends GeoAlgorithm {
    public static final String LAYERS = "LAYERS";
    public static final String RESULT = "RESULT";
    protected double m_dValue;
    protected double m_dValue2;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"CombineMasks"));
        this.setGroup(Sextante.getText((String)"Calculus_tools_for_raster_layer"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(LAYERS, Sextante.getText((String)"Layers"), 1, true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        ArrayList list = (ArrayList)this.m_Parameters.getParameterValueAsObject(LAYERS);
        IRasterLayer[] grids = new IRasterLayer[list.size()];
        for (int i = 0; i < grids.length; ++i) {
            grids[i] = (IRasterLayer)list.get(i);
            grids[i].setWindowExtent(this.m_AnalysisExtent);
        }
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5, this.m_AnalysisExtent);
        result.setNoDataValue(0.0);
        result.assignNoData();
        int iNX = this.m_AnalysisExtent.getNX();
        int iNY = this.m_AnalysisExtent.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                int i;
                for (i = 0; i < grids.length; ++i) {
                    double dValue = grids[i].getCellValueAsDouble(x, y);
                    if (grids[i].isNoDataValue(dValue)) continue;
                    result.setCellValue(x, y, 1.0);
                    break;
                }
                if (i < grids.length) continue;
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

