/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.histogram;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class HistogramAlgorithm
extends GeoAlgorithm {
    private static final int CLASS_COUNT = 100;
    public static final String GRID = "GRID";
    public static final String GRAPH = "GRAPH";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double z;
        int x;
        int y;
        double dMin = 0.0;
        double dMax = 0.0;
        double[] Count = new double[101];
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        input.setFullExtent();
        int iNX = input.getNX();
        int iNY = input.getNY();
        int A = 0;
        for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (x = 0; x < iNX; ++x) {
                z = input.getCellValueAsDouble(x, y);
                if (input.isNoDataValue(z)) continue;
                if (A <= 0) {
                    dMin = dMax = z;
                } else if (dMin > z) {
                    dMin = z;
                } else if (dMax < z) {
                    dMax = z;
                }
                ++A;
            }
        }
        double dInterval = (dMax - dMin) / 100.0;
        if (A > 0 && dMin < dMax) {
            int j;
            int i;
            for (y = 0; y < iNY; ++y) {
                for (x = 0; x < iNX; ++x) {
                    z = input.getCellValueAsDouble(x, y);
                    if (input.isNoDataValue(z)) continue;
                    i = (int)((z - dMin) / dInterval);
                    int n = Math.min(i, 100);
                    Count[n] = Count[n] + 1.0;
                }
            }
            ArrayList<Double> list = new ArrayList<Double>();
            for (i = 0; i < Count.length; ++i) {
                int iCount = (int)(10000.0 * Count[i] / (double)A);
                for (j = 0; j < iCount; ++j) {
                    list.add(new Double(dMin + dInterval * (double)i));
                }
            }
            double[] countForHistogram = new double[list.size()];
            for (j = 0; j < list.size(); ++j) {
                countForHistogram[j] = (Double)list.get(j);
            }
            HistogramDataset dataset = new HistogramDataset();
            dataset.addSeries((Comparable)((Object)input.getName()), countForHistogram, 100);
            JFreeChart chart = ChartFactory.createHistogram((String)"", null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            ChartPanel jPanelChart = new ChartPanel(chart);
            jPanelChart.setMouseZoomable(true, true);
            jPanelChart.setPreferredSize(new Dimension(500, 300));
            jPanelChart.setPreferredSize(new Dimension(500, 300));
            jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.addOutputChart(GRAPH, Sextante.getText((String)"Histogram") + "[" + input.getName() + "]", jPanelChart);
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Histogram"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Raster_layer"), true);
            this.addOutputChart(GRAPH, Sextante.getText((String)"Histogram"), null);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

