/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.channelNetwork;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;

public class ChannelNetworkAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String THRESHOLDLAYER = "THRESHOLDLAYER";
    public static final String THRESHOLD = "THRESHOLD";
    public static final String NETWORK = "NETWORK";
    public static final String NETWORKVECT = "NETWORKVECT";
    private int m_iMethod;
    private int m_iNX;
    private int m_iNY;
    private double m_dThreshold;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Threshold = null;
    private IRasterLayer m_Network;
    private ArrayList m_HeadersAndJunctions;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Threshold = this.m_Parameters.getParameterValueAsRasterLayer(THRESHOLDLAYER);
        this.m_dThreshold = this.m_Parameters.getParameterValueAsDouble(THRESHOLD);
        this.m_Network = this.getNewRasterLayer(NETWORK, Sextante.getText((String)"Channel_network"), 3);
        this.m_Network.assign(0.0);
        AnalysisExtent extent = this.m_Network.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Threshold.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateChannelNetwork();
        this.m_Network.setNoDataValue(0.0);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Greater_than"), Sextante.getText((String)"Lower_than")};
        this.setName(Sextante.getText((String)"Channel_network"));
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(THRESHOLDLAYER, Sextante.getText((String)"Threshold_layer"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Criteria"), sMethod);
            this.m_Parameters.addNumericalValue(THRESHOLD, Sextante.getText((String)"Threshold"), 10000.0, 2);
            this.addOutputRasterLayer(NETWORK, Sextante.getText((String)"Channel_network"));
            this.addOutputVectorLayer(NETWORKVECT, Sextante.getText((String)"Channel_network"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateChannelNetwork() throws GeoAlgorithmExecutionException {
        ArrayList alHeaders = this.getHeaders();
        if (alHeaders != null) {
            this.m_HeadersAndJunctions = alHeaders;
            Object[] headers = alHeaders.toArray();
            Arrays.sort(headers);
            this.setProgressText(Sextante.getText((String)"Delineating_channel_network"));
            if (headers.length > 0) {
                for (int i = 0; i < headers.length && this.setProgress(i, headers.length); ++i) {
                    this.traceChannel((GridCell)headers[i]);
                }
            }
            if (!this.m_Task.isCanceled()) {
                this.calculateOrderAndAddJunctions();
                this.createVectorLayer();
            }
        }
    }

    private ArrayList getHeaders() {
        ArrayList<GridCell> headers = new ArrayList<GridCell>();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Threshold.getCellValueAsDouble(x, y);
                double dHeight1 = this.m_DEM.getCellValueAsDouble(x, y);
                if (!this.meetsChannelConditions(dValue)) continue;
                boolean bIsHeader = true;
                dHeight1 = this.m_DEM.getCellValueAsDouble(x, y);
                if (this.m_DEM.isNoDataValue(dHeight1)) continue;
                for (int iDirection = 0; iDirection < 8; ++iDirection) {
                    double dHeight2;
                    int ix = x + m_iOffsetX[iDirection];
                    int iy = y + m_iOffsetY[iDirection];
                    dValue = this.m_Threshold.getCellValueAsDouble(ix, iy);
                    if (!this.meetsChannelConditions(dValue) || !((dHeight2 = this.m_DEM.getCellValueAsDouble(ix, iy)) >= dHeight1)) continue;
                    bIsHeader = false;
                    break;
                }
                if (!bIsHeader) continue;
                headers.add(new GridCell(x, y, this.m_DEM.getCellValueAsDouble(x, y)));
            }
        }
        if (this.m_Task.isCanceled()) {
            return null;
        }
        return headers;
    }

    private boolean meetsChannelConditions(double dValue) {
        if (this.m_iMethod == 0) {
            return dValue > this.m_dThreshold;
        }
        if (this.m_iMethod == 1) {
            return dValue < this.m_dThreshold;
        }
        return false;
    }

    private void traceChannel(GridCell cell) {
        boolean bContinue = true;
        int x = cell.getX();
        int y = cell.getY();
        do {
            this.m_Network.setCellValue(x, y, -1.0);
            int iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y);
            if (iDirection >= 0) {
                x += m_iOffsetX[iDirection];
                y += m_iOffsetY[iDirection];
                continue;
            }
            bContinue = false;
        } while (bContinue && !this.m_Task.isCanceled());
    }

    private void calculateOrderAndAddJunctions() {
        this.setProgressText(Sextante.getText((String)"Calculating_orders"));
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.getStrahlerOrder(x, y);
            }
        }
    }

    private int getStrahlerOrder(int x, int y) {
        int iMaxOrder = 1;
        int iOrder = 1;
        int iMaxOrderCells = 0;
        int iUpslopeChannelCells = 0;
        if (this.m_Network.getCellValueAsInt(x, y) == -1) {
            for (int i = 0; i < 8; ++i) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                int iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy);
                if (iDirection != (i + 4) % 8 || (iOrder = this.m_Network.getCellValueAsInt(ix, iy)) == 0) continue;
                ++iUpslopeChannelCells;
                iOrder = this.m_Network.getCellValueAsInt(ix, iy);
                if (iOrder == -1) {
                    iOrder = this.getStrahlerOrder(ix, iy);
                }
                if (iOrder > iMaxOrder) {
                    iMaxOrder = iOrder;
                    iMaxOrderCells = 1;
                    continue;
                }
                if (iOrder != iMaxOrder) continue;
                ++iMaxOrderCells;
            }
            if (iMaxOrderCells > 1) {
                ++iMaxOrder;
            }
            if (iUpslopeChannelCells > 1) {
                this.m_HeadersAndJunctions.add(new GridCell(x, y, this.m_DEM.getCellValueAsDouble(x, y)));
            }
            this.m_Network.setCellValue(x, y, (double)iMaxOrder);
        }
        return iMaxOrder;
    }

    private void createVectorLayer() throws GeoAlgorithmExecutionException {
        int iIndexDownslope = -1;
        AnalysisExtent extent = this.m_DEM.getWindowGridExtent();
        Object[] values = new Object[4];
        String[] sNames = new String[]{Sextante.getText((String)"ID"), Sextante.getText((String)"Length"), Sextante.getText((String)"Order"), Sextante.getText((String)"Next")};
        Class[] types = new Class[]{Integer.class, Double.class, Integer.class, Integer.class};
        IVectorLayer network = this.getNewVectorLayer(NETWORKVECT, Sextante.getText((String)"Channel_network"), 1, types, sNames);
        Object[] headers = this.m_HeadersAndJunctions.toArray();
        Arrays.sort(headers);
        this.setProgressText(Sextante.getText((String)"Creating_vector_layer"));
        for (int i = headers.length - 1; i > -1 && this.setProgress(headers.length - i, headers.length); --i) {
            GridCell cell = (GridCell)headers[i];
            int x = cell.getX();
            int y = cell.getY();
            ArrayList<Coordinate> coordsList = new ArrayList<Coordinate>();
            Point2D pt = extent.getWorldCoordsFromGridCoords(cell);
            coordsList.add(new Coordinate(pt.getX(), pt.getY()));
            double dLength = 0.0;
            int iOrder = this.m_Network.getCellValueAsInt(x, y);
            boolean bContinue = true;
            do {
                int iDirection;
                if ((iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y)) >= 0) {
                    int ix = x + m_iOffsetX[iDirection];
                    int iy = y + m_iOffsetY[iDirection];
                    cell = new GridCell(ix, iy, this.m_DEM.getCellValueAsDouble(ix, iy));
                    pt = extent.getWorldCoordsFromGridCoords(cell);
                    coordsList.add(new Coordinate(pt.getX(), pt.getY()));
                    dLength += this.m_DEM.getDistToNeighborInDir(iDirection);
                    iIndexDownslope = this.m_HeadersAndJunctions.indexOf(cell);
                    if (iIndexDownslope != -1) {
                        bContinue = false;
                    }
                    x = ix;
                    y = iy;
                    continue;
                }
                bContinue = false;
            } while (bContinue && !this.m_Task.isCanceled());
            values[0] = new Integer(i);
            values[1] = new Double(dLength);
            values[2] = new Integer(iOrder);
            values[3] = new Integer(iIndexDownslope);
            Coordinate[] coords = new Coordinate[coordsList.size()];
            for (int j = 0; j < coords.length; ++j) {
                coords[j] = (Coordinate)coordsList.get(j);
            }
            LineString geom = new GeometryFactory().createLineString(coords);
            network.addFeature((Geometry)geom, values);
        }
    }
}

