/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.calibrate;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CalibrateAlgorithm
extends GeoAlgorithm {
    private static final String INPUT = "INPUT";
    private static final String METHOD = "METHOD";
    private static final String STDDEV = "STDDEV";
    private static final String MEAN = "MEAN";
    private static final String GAIN = "GAIN";
    private static final String OFFSET = "OFFSET";
    private static final String CALIBRATED = "CALIBRATED";

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Average_and_standard_deviation"), Sextante.getText((String)"Gain_and_offset")};
        this.setName(Sextante.getText((String)"Calibrate_an_image"));
        this.setGroup(Sextante.getText((String)"Image_processing"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Image_to_calibrate"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(STDDEV, Sextante.getText((String)"Resulting_standard_deviation"), 1.0, 2);
            this.m_Parameters.addNumericalValue(MEAN, Sextante.getText((String)"Resulting_average"), 0.0, 2);
            this.m_Parameters.addNumericalValue(GAIN, Sextante.getText((String)"Gain"), 1.0, 2);
            this.m_Parameters.addNumericalValue(OFFSET, Sextante.getText((String)"Offset"), 0.0, 2);
            this.addOutputRasterLayer(CALIBRATED, Sextante.getText((String)"Calibrated_image"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        double dMean = this.m_Parameters.getParameterValueAsDouble(MEAN);
        double dStdDev = this.m_Parameters.getParameterValueAsDouble(STDDEV);
        double dGain = this.m_Parameters.getParameterValueAsDouble(GAIN);
        double dOffset = this.m_Parameters.getParameterValueAsDouble(OFFSET);
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        input.setFullExtent();
        IRasterLayer output = this.getNewRasterLayer(CALIBRATED, Sextante.getText((String)"Calibrated_image"), input.getDataType(), input.getWindowGridExtent());
        int iNX = input.getNX();
        int iNY = input.getNY();
        if (iMethod == 0) {
            double dMeanIn = input.getMeanValue();
            double dStdDevIn = Math.sqrt(input.getVariance());
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    double dCellValue = input.getCellValueAsDouble(x, y);
                    if (input.isNoDataValue(dCellValue)) {
                        output.setNoData(x, y);
                        continue;
                    }
                    double dOutput = (dCellValue - dMeanIn) / dStdDevIn * dStdDev + dMean;
                    output.setCellValue(x, y, dOutput);
                }
            }
        } else {
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    double dCellValue = input.getCellValueAsDouble(x, y);
                    if (input.isNoDataValue(dCellValue)) {
                        output.setNoData(x, y);
                        continue;
                    }
                    output.setCellValue(x, y, dGain * dCellValue + dOffset);
                }
            }
        }
        return !this.m_Task.isCanceled();
    }
}

