/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.erosionDilation;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ErosionDilationAlgorithm
extends GeoAlgorithm {
    public static final int ERODE = 0;
    public static final int DILATE = 1;
    public static final String LAYER = "LAYER";
    public static final String OPERATION = "OPERATION";
    public static final String RADIUS = "RADIUS";
    public static final String RESULT = "RESULT";
    protected final byte NO_DATA = 0;
    private int m_iRadius;
    private boolean[][] m_bIsValidCell;
    private boolean[][] m_bIsForegroundCell;
    private IRasterLayer m_Image;
    private int m_iOperationType;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Erosion"), Sextante.getText((String)"Dilation")};
        this.setUserCanDefineAnalysisExtent(false);
        this.setName(Sextante.getText((String)"Erosion-Dilation"));
        this.setGroup(Sextante.getText((String)"Image_processing"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Image"), true);
            this.m_Parameters.addSelection(OPERATION, Sextante.getText((String)"Operation"), sMethod);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 1, 1.0, 1.0, 20.0);
            this.addOutputRasterLayer(RESULT, this.getName());
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int x;
        int y;
        int iValidCells = 0;
        this.m_iRadius = this.m_Parameters.getParameterValueAsInt(RADIUS);
        this.m_iOperationType = this.m_Parameters.getParameterValueAsInt(OPERATION);
        this.m_Image = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Image.setFullExtent();
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 0, this.m_Image.getWindowGridExtent());
        result.setNoDataValue(0.0);
        result.assignNoData();
        int iNX = this.m_Image.getNX();
        int iNY = this.m_Image.getNY();
        this.m_bIsValidCell = new boolean[2 * this.m_iRadius + 1][2 * this.m_iRadius + 1];
        this.m_bIsForegroundCell = new boolean[2 * this.m_iRadius + 1][2 * this.m_iRadius + 1];
        for (y = -this.m_iRadius; y < this.m_iRadius + 1; ++y) {
            for (x = -this.m_iRadius; x < this.m_iRadius + 1; ++x) {
                double dDist = Math.sqrt(x * x + y * y);
                if (dDist <= (double)this.m_iRadius) {
                    this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius] = true;
                    ++iValidCells;
                    continue;
                }
                this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius] = false;
            }
        }
        for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (x = 0; x < iNX; ++x) {
                this.setNeighborhoodValues(x, y);
                result.setCellValue(x, y, (double)this.operate());
            }
        }
        return !this.m_Task.isCanceled();
    }

    private byte operate() {
        switch (this.m_iOperationType) {
            default: {
                for (int i = 0; i < this.m_bIsValidCell.length; ++i) {
                    for (int j = 0; j < this.m_bIsValidCell[0].length; ++j) {
                        if (!this.m_bIsValidCell[i][j] || this.m_bIsForegroundCell[i][j]) continue;
                        return 0;
                    }
                }
                return 1;
            }
            case 1: 
        }
        for (int i = 0; i < this.m_bIsValidCell.length; ++i) {
            for (int j = 0; j < this.m_bIsValidCell[0].length; ++j) {
                if (!this.m_bIsValidCell[i][j] || !this.m_bIsForegroundCell[i][j]) continue;
                return 1;
            }
        }
        return 0;
    }

    private void setNeighborhoodValues(int iX, int iY) {
        int iCell = 0;
        for (int y = -this.m_iRadius; y < this.m_iRadius + 1; ++y) {
            for (int x = -this.m_iRadius; x < this.m_iRadius + 1; ++x) {
                if (!this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius]) continue;
                double dValue = this.m_Image.getCellValueAsDouble(iX + x, iY + y);
                this.m_bIsForegroundCell[x + this.m_iRadius][y + this.m_iRadius] = !this.m_Image.isNoDataValue(dValue) && dValue != 0.0;
                ++iCell;
            }
        }
    }
}

