/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.fillElevationValues;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.morphometry.fillElevationValues.FeatureAndDistance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class FillElevationValuesAlgorithm
extends GeoAlgorithm {
    public static final String CONTOURS_LAYER = "CONTOURS_LAYER";
    public static final String CONTOURS_LAYER_FIELD = "CONTOURS_LAYER_FIELD";
    public static final String RESULT = "RESULT";
    public static final String DISTANCE = "DISTANCE";
    public static final String UPHILL_LAYER = "UPHILL_LAYER";
    public static final String UPHILL_LAYER_FIELD = "UPHILL_LAYER_FIELD";
    public static final String UPHILL_LAYER_INTERVAL_FIELD = "UPHILL_LAYER_INTERVAL_FIELD";
    private IVectorLayer m_Contours_Layer;
    private IVectorLayer m_Uphill_Layer;
    private IVectorLayer m_Output;
    private ArrayList<Geometry> m_Geometries;
    private ArrayList<Double> m_Elevations;
    private double m_dEquidistance;
    private STRtree m_Tree;
    private BitSet m_BitSet;
    private int m_iContoursField;
    private int m_iUphillField;
    private int m_iUphillIntervalField;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Fill_elevation_values"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(CONTOURS_LAYER, Sextante.getText((String)"Contour_lines"), 1, true);
            this.m_Parameters.addInputVectorLayer(UPHILL_LAYER, Sextante.getText((String)"Uphill_lines"), 1, true);
            this.m_Parameters.addTableField(CONTOURS_LAYER_FIELD, Sextante.getText((String)"Elevation_field"), CONTOURS_LAYER);
            this.m_Parameters.addTableField(UPHILL_LAYER_FIELD, Sextante.getText((String)"Elevation_field"), UPHILL_LAYER);
            this.m_Parameters.addTableField(UPHILL_LAYER_INTERVAL_FIELD, Sextante.getText((String)"Interval_field"), UPHILL_LAYER);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IFeature feature;
        this.m_Contours_Layer = this.m_Parameters.getParameterValueAsVectorLayer(CONTOURS_LAYER);
        this.m_Uphill_Layer = this.m_Parameters.getParameterValueAsVectorLayer(UPHILL_LAYER);
        this.m_iContoursField = this.m_Parameters.getParameterValueAsInt(CONTOURS_LAYER_FIELD);
        this.m_iUphillField = this.m_Parameters.getParameterValueAsInt(UPHILL_LAYER_FIELD);
        this.m_iUphillIntervalField = this.m_Parameters.getParameterValueAsInt(UPHILL_LAYER_FIELD);
        if (!this.checkFields()) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Wrong_field_types"));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_Contours_Layer.getName(), 1, this.m_Contours_Layer.getFieldTypes(), this.m_Contours_Layer.getFieldNames());
        int iShapeCount = this.m_Contours_Layer.getShapesCount();
        this.m_BitSet = new BitSet(iShapeCount);
        this.m_Tree = new STRtree();
        this.setProgressText(Sextante.getText((String)"Reading_input_data"));
        int i = 0;
        IFeatureIterator iter = this.m_Contours_Layer.iterator();
        while (iter.hasNext() && !this.m_Task.isCanceled()) {
            feature = iter.next();
            Geometry geom = feature.getGeometry();
            Envelope envelope = geom.getEnvelopeInternal();
            FeatureAndIndex fai = new FeatureAndIndex(feature, i);
            this.m_Tree.insert(envelope, (Object)fai);
            if (i % 50 == 0) {
                this.m_Task.setProgress(i, iShapeCount);
            }
            ++i;
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        iter = this.m_Uphill_Layer.iterator();
        this.setProgressText(Sextante.getText((String)"computing_elevation_values"));
        i = 0;
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            feature = iter.next();
            this.computeElevations(feature);
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private boolean checkFields() {
        Class contoursField = this.m_Contours_Layer.getFieldType(this.m_iContoursField);
        Class uphillField = this.m_Uphill_Layer.getFieldType(this.m_iUphillField);
        Class intervalField = this.m_Uphill_Layer.getFieldType(this.m_iUphillIntervalField);
        return Number.class.isAssignableFrom(contoursField) && Number.class.isAssignableFrom(uphillField) && Number.class.isAssignableFrom(intervalField);
    }

    private void computeElevations(IFeature feature) {
        Geometry geom = feature.getGeometry();
        Coordinate initPt = geom.getCoordinates()[0];
        Object elevation = feature.getRecord().getValue(this.m_iUphillField);
        Object interval = feature.getRecord().getValue(this.m_iUphillIntervalField);
        try {
            String sElevation = elevation.toString();
            double dElevation = Double.parseDouble(sElevation);
            String sInterval = interval.toString();
            double dInterval = Double.parseDouble(sInterval);
            Envelope envelope = geom.getEnvelopeInternal();
            List lines = this.m_Tree.query(envelope);
            ArrayList<FeatureAndDistance> features = new ArrayList<FeatureAndDistance>();
            for (int i = 0; i < lines.size(); ++i) {
                FeatureAndIndex fai = (FeatureAndIndex)lines.get(i);
                Geometry line = fai.feature.getGeometry();
                this.m_BitSet.set(fai.index);
                Coordinate pt = line.intersection(geom).getCoordinate();
                if (pt == null) continue;
                double dDist = initPt.distance(pt);
                FeatureAndDistance fad = new FeatureAndDistance(fai.feature, dDist);
                features.add(fad);
            }
            Object[] featuresArray = features.toArray(new FeatureAndDistance[0]);
            Arrays.sort(featuresArray);
            int i = 0;
            while (i < featuresArray.length) {
                Object[] record = ((FeatureAndDistance)featuresArray[i]).getFeature().getRecord().getValues();
                record[this.m_iContoursField] = new Double(dElevation);
                this.m_Output.addFeature(((FeatureAndDistance)featuresArray[i]).getFeature().getGeometry(), record);
                ++i;
                dElevation += dInterval;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private class FeatureAndIndex {
        public IFeature feature;
        public int index;

        public FeatureAndIndex(IFeature feature, int index) {
            this.feature = feature;
            this.index = index;
        }
    }
}

