/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.pointAnalysis.medianCenter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.awt.geom.Rectangle2D;

public class MedianCenterAlgorithm
extends GeoAlgorithm {
    public static final int METHOD_NOT_WEIGHTED = 0;
    public static final int METHOD_WEIGHTED = 1;
    public static final String METHOD = "METHOD";
    public static final String FIELD = "FIELD";
    public static final String POINTS = "POINTS";
    public static final String RESULT = "RESULT";
    private static final int ITERATIONS = 100;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dSumX = 0.0;
        double dSumY = 0.0;
        double dSumWeight = 0.0;
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int iCount = layer.getShapesCount();
        if (iCount == 0) {
            throw new GeoAlgorithmExecutionException("0 points in layer");
        }
        double[] dX = new double[iCount];
        double[] dY = new double[iCount];
        double[] dWeight = new double[iCount];
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            dX[i] = coord.x;
            dY[i] = coord.y;
            if (iMethod == 1) {
                try {
                    dWeight[i] = Double.parseDouble(feature.getRecord().getValue(iField).toString());
                }
                catch (Exception e) {
                    dWeight[i] = 1.0;
                }
            } else {
                dWeight[i] = 1.0;
            }
            dSumWeight += dWeight[i];
            dSumX += dWeight[i] * dX[i];
            dSumY += dWeight[i] * dY[i];
            ++i;
        }
        iter.close();
        double xCenter = dSumX / dSumWeight;
        double yCenter = dSumY / dSumWeight;
        for (int j = 0; j < 100; ++j) {
            dSumX = 0.0;
            dSumY = 0.0;
            dSumWeight = 0.0;
            this.setProgressText(Sextante.getText((String)"Iteration") + Integer.toString(j));
            for (i = 0; i < iCount && this.setProgress(i, iCount); ++i) {
                double dDist = Math.sqrt(Math.pow(dX[i] - xCenter, 2.0) + Math.pow(dY[i] - yCenter, 2.0));
                double dDistWeight = dWeight[i] / dDist;
                dSumWeight += dDistWeight;
                dSumX += dDistWeight * dX[i];
                dSumY += dDistWeight * dY[i];
            }
            xCenter = dSumX / dSumWeight;
            yCenter = dSumY / dSumWeight;
        }
        GeometryFactory gf = new GeometryFactory();
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Median_center"), 1, new Class[]{Double.class}, new String[]{Sextante.getText((String)"Coord")});
        Coordinate[] coords = new Coordinate[2];
        Rectangle2D rect = layer.getFullExtent();
        Object[] value = new Object[]{new Double(xCenter)};
        coords[0] = new Coordinate(xCenter, rect.getMinY());
        coords[1] = new Coordinate(xCenter, rect.getMaxY());
        LineString line = gf.createLineString(coords);
        output.addFeature((Geometry)line, value);
        value[0] = new Double(yCenter);
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(rect.getMinX(), yCenter), new Coordinate(rect.getMaxX(), yCenter)};
        LineString line2 = gf.createLineString(coords2);
        output.addFeature((Geometry)line2, value);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sOptions = new String[]{Sextante.getText((String)"Median_center"), Sextante.getText((String)"Weighted_median_center")};
        this.setName(Sextante.getText((String)"Median_center"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Weights"), POINTS);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sOptions);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Median_center"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

