/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.rasterize.interpolationBase;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.closestpts.NearestNeighbourFinder;
import es.unex.sextante.closestpts.PtAndDistance;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;

public abstract class BaseInterpolationAlgorithm
extends GeoAlgorithm {
    protected double NO_DATA;
    public static final String LAYER = "LAYER";
    public static final String DIST = "DIST";
    public static final String FIELD = "FIELD";
    public static final String RESULT = "RESULT";
    protected double m_dDistance;
    protected int m_iField;
    protected NearestNeighbourFinder m_SearchEngine;
    protected PtAndDistance[] m_NearestPoints;
    protected IVectorLayer m_Layer;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Point_layer"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LAYER);
            this.m_Parameters.addNumericalValue(DIST, Sextante.getText((String)"Search_radius"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.NO_DATA = this.m_OutputFactory.getDefaultNoDataValue();
        this.setValues();
        this.m_SearchEngine = new NearestNeighbourFinder(this.m_Layer, this.m_iField, this.m_Task);
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.m_Layer.getName() + Sextante.getText((String)"[interpolated]"), 5);
        int iNX = this.m_AnalysisExtent.getNX();
        int iNY = this.m_AnalysisExtent.getNY();
        this.setProgressText(Sextante.getText((String)"Interpolating"));
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                result.setCellValue(x, y, this.getValueAt(x, y));
            }
        }
        this.createCrossValidationTable();
        return !this.m_Task.isCanceled();
    }

    protected void createCrossValidationTable() throws UnsupportedOutputChannelException {
        Object[] values = new Object[5];
        String[] sFields = new String[]{"X", "Y", "Real_value", "Esti_value", Sextante.getText((String)"Diference")};
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class};
        String sTableName = Sextante.getText((String)"Cross_validation_[") + this.m_Layer.getName() + "]";
        ITable table = this.getNewTable("CROSSVALIDATION", sTableName, types, sFields);
        try {
            this.setProgressText(Sextante.getText((String)"Creating_cross_validation"));
            int iPoints = this.m_Layer.getShapesCount();
            IFeatureIterator iter = this.m_Layer.iterator();
            int i = 0;
            while (iter.hasNext() && this.setProgress(i, iPoints)) {
                double z;
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                Coordinate coord = geom.getCoordinate();
                double x = coord.x;
                double y = coord.y;
                values[0] = new Double(x);
                values[1] = new Double(y);
                try {
                    z = Double.parseDouble(feature.getRecord().getValue(this.m_iField).toString());
                }
                catch (NumberFormatException e) {
                    z = 0.0;
                }
                values[2] = new Double(z);
                double dValue = this.getValueAt(x, y);
                if (dValue != this.NO_DATA) {
                    values[3] = new Double(dValue);
                    values[4] = new Double(dValue - z);
                    table.addRecord(values);
                }
                ++i;
            }
            iter.close();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return;
        }
    }

    protected void setValues() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_dDistance = this.m_Parameters.getParameterValueAsDouble(DIST);
        if (this.m_dDistance == 0.0) {
            this.m_dDistance = Double.MAX_VALUE;
        }
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
    }

    protected double getValueAt(int x, int y) {
        Point2D pt = this.m_AnalysisExtent.getWorldCoordsFromGridCoords(new GridCell(x, y, 0.0));
        this.m_NearestPoints = this.m_SearchEngine.getClosestPoints(pt.getX(), pt.getY(), this.m_dDistance);
        double dValue = this.interpolate(pt.getX(), pt.getY());
        return dValue;
    }

    protected double getValueAt(double x, double y) {
        try {
            PtAndDistance[] nearestPoints = this.m_SearchEngine.getClosestPoints(x, y, this.m_dDistance);
            this.m_NearestPoints = new PtAndDistance[nearestPoints.length - 1];
            int iIndex = 0;
            for (PtAndDistance element : nearestPoints) {
                try {
                    if (element.getDist() == 0.0) continue;
                    this.m_NearestPoints[iIndex] = element;
                    ++iIndex;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.interpolate(x, y);
        }
        catch (Exception e) {
            return this.NO_DATA;
        }
    }

    protected abstract double interpolate(double var1, double var3);
}

