/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.statisticalMethods.pca;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.parameters.RasterLayerAndBand;
import java.util.ArrayList;
import java.util.Arrays;

public class PCAAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String NBANDS = "NBANDS";
    public static final String INPUT = "INPUT";
    private static double NODATA = -9999999.0;
    private ArrayList m_RasterLayers;
    private IRasterLayer[] m_Windows;
    private int[] m_iBands;
    private int m_iNX;
    private int m_iNY;
    private double[] m_dMean;
    private int m_iNumBands;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Statistical_methods"));
        this.setName(Sextante.getText((String)"Principal_Components_Analysis"));
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Input_bands"), 7, true);
            this.m_Parameters.addNumericalValue(NBANDS, Sextante.getText((String)"Bands_number"), 1, 1.0, 1.0, 2.147483647E9);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Principal_Components_Analysis"), -1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_RasterLayers = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_iNumBands = this.m_Parameters.getParameterValueAsInt(NBANDS);
        if (this.m_RasterLayers.size() == 0 || this.m_iNumBands > this.m_RasterLayers.size()) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Error_not_enough_bands_selected"));
        }
        this.m_iNX = this.getAnalysisExtent().getNX();
        this.m_iNY = this.getAnalysisExtent().getNY();
        double[][] coVar = this.getCovarMatrix();
        Matrix coVarMatrix = new Matrix(coVar);
        EigenvalueDecomposition eigenvalueDecomp = new EigenvalueDecomposition(coVarMatrix);
        Matrix eigenvectors = eigenvalueDecomp.getV();
        double[] eigenvalues = eigenvalueDecomp.getRealEigenvalues();
        Object[] vao = new ValueAndOrder[eigenvalues.length];
        for (int i = 0; i < eigenvalues.length; ++i) {
            vao[i] = new ValueAndOrder(eigenvalues[i], i);
        }
        Arrays.sort(vao);
        IRasterLayer pca = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Principal_Components_Analysis"), 5, this.m_iNumBands);
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                for (int iBand = 0; iBand < this.m_iNumBands && this.setProgress(iBand, this.m_iNumBands); ++iBand) {
                    double dPCValue = 0.0;
                    for (int iInputBand = 0; iInputBand < this.m_RasterLayers.size(); ++iInputBand) {
                        double dValue = this.m_Windows[iInputBand].getCellValueAsDouble(x, y, this.m_iBands[iInputBand]);
                        dPCValue += eigenvectors.get(iInputBand, ((ValueAndOrder)vao[iBand]).getOrder()) * dValue;
                    }
                    pca.setCellValue(x, y, iBand, dPCValue);
                }
            }
        }
        return !this.m_Task.isCanceled();
    }

    private double[][] getCovarMatrix() {
        int i;
        double[][] dCovar = new double[this.m_RasterLayers.size()][this.m_RasterLayers.size()];
        this.m_dMean = new double[this.m_RasterLayers.size()];
        this.m_Windows = new IRasterLayer[this.m_RasterLayers.size()];
        this.m_iBands = new int[this.m_RasterLayers.size()];
        for (i = 0; i < this.m_RasterLayers.size(); ++i) {
            RasterLayerAndBand rab = (RasterLayerAndBand)this.m_RasterLayers.get(i);
            this.m_Windows[i] = rab.getRasterLayer();
            this.m_Windows[i].setWindowExtent(this.getAnalysisExtent());
            this.m_Windows[i].setInterpolationMethod(4);
            this.m_dMean[i] = this.m_Windows[i].getMeanValue();
            this.m_iBands[i] = rab.getBand();
        }
        int iTotal = (int)((double)(this.m_RasterLayers.size() * this.m_RasterLayers.size()) / 2.0);
        int iCount = 0;
        for (i = 0; i < this.m_RasterLayers.size() - 1 && this.setProgress(iCount, iTotal); ++i) {
            dCovar[i][i] = 1.0;
            ++iCount;
            for (int j = i + 1; j < this.m_RasterLayers.size(); ++j) {
                double d = this.getCovar(i, j);
                dCovar[j][i] = d;
                dCovar[i][j] = d;
                ++iCount;
            }
        }
        return dCovar;
    }

    private double getCovar(int i, int j) {
        int iValues = 0;
        double dSum = 0.0;
        int y = 0;
        if (y < this.m_iNY) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValuei = this.m_Windows[i].getCellValueAsDouble(x, y, this.m_iBands[i]);
                double dValuej = this.m_Windows[j].getCellValueAsDouble(x, y, this.m_iBands[j]);
                if (this.m_Windows[i].isNoDataValue(dValuei) || this.m_Windows[j].isNoDataValue(dValuej)) continue;
                dSum += (dValuei - this.m_dMean[i]) * (dValuej - this.m_dMean[j]);
                ++iValues;
            }
            if (iValues > 1) {
                return dSum / (double)(iValues - 1);
            }
            return NODATA;
        }
        return NODATA;
    }

    private class ValueAndOrder
    implements Comparable {
        private final int m_iOrder;
        private final double m_dValue;

        public ValueAndOrder(double dValue, int iOrder) {
            this.m_dValue = dValue;
            this.m_iOrder = iOrder;
        }

        public int getOrder() {
            return this.m_iOrder;
        }

        public double getValue() {
            return this.m_dValue;
        }

        public int compareTo(Object vao) throws ClassCastException {
            if (!(vao instanceof ValueAndOrder)) {
                throw new ClassCastException();
            }
            double dValue = ((ValueAndOrder)vao).getValue();
            double dDif = this.m_dValue - dValue;
            if (dDif > 0.0) {
                return 1;
            }
            if (dDif < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

