/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.statisticalMethods.pdfBinomial;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.pdf.PDF;

public class PDFBinomialAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String P = "P";
    public static final String N = "N";
    public static final String CDF = "CDF";
    public static final String PROBABILITY = "PROBABILITY";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Bernouilli_probability_distribution"));
        this.setGroup(Sextante.getText((String)"Statistical_methods"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Raster_layer"), true);
            this.m_Parameters.addNumericalValue(P, Sextante.getText((String)"Success_probability"), 2, 0.5, 0.0, 1.0);
            this.m_Parameters.addNumericalValue(N, Sextante.getText((String)"Number_of_trials"), 1, 10.0, 1.0, 2.147483647E9);
            this.m_Parameters.addBoolean(CDF, Sextante.getText((String)"Accumulated_probability"), false);
            this.addOutputRasterLayer(PROBABILITY, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer layer = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        boolean bCDF = this.m_Parameters.getParameterValueAsBoolean(CDF);
        double dProb = this.m_Parameters.getParameterValueAsDouble(P);
        int iN = this.m_Parameters.getParameterValueAsInt(N);
        layer.setFullExtent();
        AnalysisExtent gridExtent = new AnalysisExtent((ILayer)layer);
        IRasterLayer result = this.getNewRasterLayer(PROBABILITY, Sextante.getText((String)"Probability__binomial"), 5, gridExtent);
        int iNX = layer.getNX();
        int iNY = layer.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = layer.getCellValueAsDouble(x, y);
                if (!layer.isNoDataValue(dValue)) {
                    if (bCDF) {
                        result.setCellValue(x, y, PDF.binomialCDF((double)dProb, (int)iN, (int)((int)dValue)));
                        continue;
                    }
                    result.setCellValue(x, y, PDF.binomial((double)dProb, (int)iN, (int)((int)dValue)));
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

