/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.vectorBasicStats;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.text.DecimalFormat;

public class VectorBasicStatsAlgorithm
extends GeoAlgorithm {
    public static final String STATS = "STATS";
    public static final String FIELD = "FIELD";
    public static final String LAYER = "LAYER";
    public static final String MEAN = "MEAN";
    public static final String MEAN_SQUARED = "MEAN_SQUARED";
    public static final String MIN = "MIN";
    public static final String MAX = "MAX";
    public static final String VARIANCE = "VARIANCE";
    public static final String SUM = "SUM";
    public static final String COEF_OF_VARIATION = "COEF_OF_VARIATION";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        SimpleStats stats = new SimpleStats();
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int i = 0;
        int iCount = layer.getShapesCount();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            try {
                double dValue = Double.parseDouble(feature.getRecord().getValue(iField).toString());
                stats.addValue(dValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        DecimalFormat df = new DecimalFormat("##.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Statistics"));
        doc.addHeader(Sextante.getText((String)"Basic_statistics"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Mean_value") + ": " + df.format(stats.getMean()));
        doc.addListElement(Sextante.getText((String)"Mean_squared_value") + ": " + df.format(stats.getRMS()));
        doc.addListElement(Sextante.getText((String)"Min_value") + ": " + df.format(stats.getMin()));
        doc.addListElement(Sextante.getText((String)"Max_value") + ": " + df.format(stats.getMax()));
        doc.addListElement(Sextante.getText((String)"Variance") + ": " + df.format(stats.getVariance()));
        doc.addListElement(Sextante.getText((String)"Total_sum") + ": " + df.format(stats.getSum()));
        doc.addListElement(Sextante.getText((String)"Coefficient_of_variation") + ": " + df.format(stats.getCoeffOfVar()));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(STATS, Sextante.getText((String)"Statistics") + "[" + layer.getName() + "]", doc.getHTMLCode());
        this.addOutputNumericalValue(MEAN, stats.getMean());
        this.addOutputNumericalValue(MEAN_SQUARED, stats.getRMS());
        this.addOutputNumericalValue(MIN, stats.getMin());
        this.addOutputNumericalValue(MAX, stats.getMax());
        this.addOutputNumericalValue(VARIANCE, stats.getVariance());
        this.addOutputNumericalValue(SUM, stats.getSum());
        this.addOutputNumericalValue(COEF_OF_VARIATION, stats.getCoeffOfVar());
        return true;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Basic_statistics"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LAYER);
            this.addOutputText(STATS, Sextante.getText((String)"Statistics"));
            this.addOutputNumericalValue(MEAN, Sextante.getText((String)"Mean_value"));
            this.addOutputNumericalValue(MEAN_SQUARED, Sextante.getText((String)"Mean_squared_value"));
            this.addOutputNumericalValue(MIN, Sextante.getText((String)"Minimum_value"));
            this.addOutputNumericalValue(MAX, Sextante.getText((String)"Maximum_value"));
            this.addOutputNumericalValue(VARIANCE, Sextante.getText((String)"Variance"));
            this.addOutputNumericalValue(SUM, Sextante.getText((String)"Total_sum"));
            this.addOutputNumericalValue(COEF_OF_VARIATION, Sextante.getText((String)"Coefficient_of_variation"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

