/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.linearIsolinesFromTin;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.tin.linearIsolinesFromTin.LinearContourLines;
import es.unex.sextante.tin.smoothTinBezier.Bezier;
import es.unex.sextante.tin.smoothTinBezier.BezierSurface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class LinearIsolinesFromTinAlgorithm
extends GeoAlgorithm {
    public static final String TIN = "TIN";
    public static final String ISOLINES = "ISOLINES";
    public static final String EQUIDISTANCE = "EQUIDISTANCE";
    public static final String LoD = "LoD";
    public static final String ClusterTol = "ClusterTol";
    public static final String Smooth = "Smooth";
    private IVectorLayer m_Triangles;
    private IVectorLayer m_Isolines;
    private double m_EquiDistance;
    private int m_LoD;
    private double m_ClusterTol;
    private double m_Smooth;
    private STRtree trianglesIndex;
    Coordinate[][] triangles;
    TreeMap breakLines = new TreeMap();
    Bezier[] miniBezierTriangles;
    double scaleZ;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Extract_isolines"));
        this.setGroup(Sextante.getText((String)TIN));
        this.setUserCanDefineAnalysisExtent(false);
        String[] sDistance = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        try {
            this.m_Parameters.addInputVectorLayer(TIN, Sextante.getText((String)TIN), 2, true);
            this.m_Parameters.addNumericalValue(EQUIDISTANCE, Sextante.getText((String)"Equidistance"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addSelection(LoD, Sextante.getText((String)"Level_of_detail"), sDistance);
            this.m_Parameters.addNumericalValue(ClusterTol, Sextante.getText((String)"Cluster_tolerance"), 2, 0.001, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(Smooth, Sextante.getText((String)"Smoothing_coef"), 2, 1.0, 0.1, 1.0);
            this.addOutputVectorLayer(ISOLINES, Sextante.getText((String)"Result"), 1);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double maxZValue = Double.NEGATIVE_INFINITY;
        double minZValue = Double.POSITIVE_INFINITY;
        this.m_Triangles = this.m_Parameters.getParameterValueAsVectorLayer(TIN);
        this.m_EquiDistance = this.m_Parameters.getParameterValueAsDouble(EQUIDISTANCE);
        this.m_LoD = this.m_Parameters.getParameterValueAsInt(LoD);
        this.m_ClusterTol = this.m_Parameters.getParameterValueAsDouble(ClusterTol);
        this.m_Smooth = this.m_Parameters.getParameterValueAsDouble(Smooth);
        Class[] types = new Class[]{Integer.class, Double.class};
        String[] sNames = new String[]{"ID", "Value"};
        this.m_Isolines = this.getNewVectorLayer(ISOLINES, this.m_Triangles.getName() + "_Isolines", 1, types, sNames);
        int i = 0;
        int iShapeCount = this.m_Triangles.getShapesCount();
        this.triangles = new Coordinate[iShapeCount][3];
        IFeatureIterator iter = this.m_Triangles.iterator();
        try {
            this.trianglesIndex = new STRtree();
            while (iter.hasNext()) {
                IFeature feature = iter.next();
                IRecord record = feature.getRecord();
                if ((String)record.getValue(1) == "Y") {
                    this.breakLines.put(i, record.getValue(2));
                }
                this.triangles[i][0] = (Coordinate)feature.getGeometry().getCoordinates()[0].clone();
                this.triangles[i][1] = (Coordinate)feature.getGeometry().getCoordinates()[1].clone();
                this.triangles[i][2] = (Coordinate)feature.getGeometry().getCoordinates()[2].clone();
                this.trianglesIndex.insert(feature.getGeometry().getEnvelopeInternal(), (Object)new Integer(i));
                for (int k = 0; k < 2; ++k) {
                    double diffZ = this.triangles[i][k].z - this.triangles[i][k + 1].z;
                    double diffXY = Math.sqrt(Math.pow(this.triangles[i][k].x - this.triangles[i][k + 1].x, 2.0) + Math.pow(this.triangles[i][k].y - this.triangles[i][k + 1].y, 2.0));
                    if (!(this.scaleZ < Math.abs(diffZ / diffXY))) continue;
                    this.scaleZ = Math.abs(diffZ / diffXY);
                }
                this.setProgress(i, 2 * iShapeCount);
                ++i;
            }
            iter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_Triangles = null;
        iter = null;
        LinearContourLines isoLineFactory = new LinearContourLines(this.m_EquiDistance, this.m_ClusterTol);
        if (this.m_LoD != 0) {
            BezierSurface bezierSurface = new BezierSurface(this.triangles, this.trianglesIndex, this.breakLines, this.scaleZ * this.m_Smooth, this.m_LoD);
            while (bezierSurface.hasNext()) {
                this.setProgress(i++, 2 * iShapeCount);
                Coordinate[][] newTin = bezierSurface.nextTrinagle();
                isoLineFactory.countIsolines(newTin);
            }
        } else {
            isoLineFactory.countIsolines(this.triangles);
        }
        ArrayList isolines = isoLineFactory.getIsolines();
        Iterator iterIso = isolines.iterator();
        int j = 0;
        for (int l = 0; l < isolines.size(); ++l) {
            Object o = isolines.get(l);
            if (o == null) continue;
            GeometryFactory gf = new GeometryFactory();
            Iterator isoL = ((LinkedList)o).iterator();
            Coordinate[] coords = new Coordinate[((LinkedList)o).size()];
            int k = 0;
            while (isoL.hasNext()) {
                coords[k] = (Coordinate)isoL.next();
                ++k;
            }
            Object[] record = new Object[]{new Integer(j), coords[0].z};
            LineString isoline = gf.createLineString(coords);
            this.m_Isolines.addFeature((Geometry)isoline, record);
            ++j;
        }
        return !this.m_Task.isCanceled();
    }
}

