/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.tinWithBreaklines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import java.util.ArrayList;

public class TinWithBreaklinesAlgorithm
extends GeoAlgorithm {
    public static final String POINTS = "POINTS";
    public static final String LINES = "LINES";
    public static final String TRIANGLES = "TRIANGLES";
    public static final String ELEVATION_FIELD = "ELEVATION_FIELD";
    private IVectorLayer m_Points = null;
    private IVectorLayer m_Lines = null;
    private IVectorLayer m_Triangles = null;
    private int m_iElevationField;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Create_tin_with_breaklines"));
        this.setGroup(Sextante.getText((String)"TIN"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points_layer"), 0, true);
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Breaklines"), 1, true);
            this.m_Parameters.addTableField(ELEVATION_FIELD, Sextante.getText((String)"Height_field"), POINTS);
            this.addOutputVectorLayer(TRIANGLES, Sextante.getText((String)"Result"), 2);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        GeometryFactory gf = new GeometryFactory();
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        this.m_Lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            this.m_Points.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_Lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_iElevationField = this.m_Parameters.getParameterValueAsInt(ELEVATION_FIELD);
        Class[] types = new Class[]{Integer.class, String.class, Integer.class, Double.class};
        String[] sNames = new String[]{"ID", "HardLines", "type", "elevation"};
        this.m_Triangles = this.getNewVectorLayer(TRIANGLES, "TIN_" + this.m_Points.getName(), 2, types, sNames);
        int i = 0;
        ArrayList<Point> pointsList = new ArrayList<Point>();
        int iShapeCount = this.m_Points.getShapesCount();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Coordinate coord = feature.getGeometry().getCoordinate();
            try {
                double dElevation;
                coord.z = dElevation = Double.parseDouble(feature.getRecord().getValue(this.m_iElevationField).toString());
            }
            catch (Exception e) {
                throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Wrong_values_in_elevation_field"));
            }
            pointsList.add(gf.createPoint(coord));
            ++i;
        }
        iter.close();
        ArrayList<Geometry> linesList = new ArrayList<Geometry>();
        iShapeCount = this.m_Lines.getShapesCount();
        iter = this.m_Lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            linesList.add(feature.getGeometry());
            ++i;
        }
        iter.close();
        this.m_Task.setDeterminate(false);
        GeometryCollection pointsGeomcol = gf.createGeometryCollection(pointsList.toArray(new Geometry[0]));
        GeometryCollection linesGeomcol = gf.createGeometryCollection(linesList.toArray(new Geometry[0]));
        ConformingDelaunayTriangulationBuilder delaunay = new ConformingDelaunayTriangulationBuilder();
        delaunay.setSites((Geometry)pointsGeomcol);
        delaunay.setConstraints((Geometry)linesGeomcol);
        Geometry triangles = delaunay.getTriangles(gf);
        int iTriangles = triangles.getNumGeometries();
        for (int iTriangle = 0; iTriangle < iTriangles; ++iTriangle) {
            Geometry triangle = triangles.getGeometryN(iTriangle);
            Object[] record = new Object[]{new Integer(iTriangle), "", -1, this.getElevation(triangle)};
            this.m_Triangles.addFeature(triangle, record);
        }
        return !this.m_Task.isCanceled();
    }

    private double getElevation(Geometry triangle) {
        Coordinate[] coords = triangle.getCoordinates();
        return (coords[0].z + coords[1].z + coords[2].z) / 3.0;
    }
}

