/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.topology.joinAdjacentLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.FeatureImpl;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class JoinAdjacentLinesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String TOLERANCE = "TOLERANCE";
    public static final String RESULT = "RESULT";
    private double m_dTolerance;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Join_near_lines"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setIsDeterminatedProcess(false);
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_Layer"), 1, true);
            this.m_Parameters.addNumericalValue(TOLERANCE, Sextante.getText((String)"Tolerance"), 2, 5.0, 1.0E-4, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IFeature[] features;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_dTolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE);
        int idx = 0;
        int iTotal = layerIn.getShapesCount();
        IFeatureIterator iter = layerIn.iterator();
        IFeature[] newFeatures = new IFeature[iTotal];
        while (iter.hasNext()) {
            newFeatures[idx] = iter.next();
            ++idx;
        }
        int i = 1;
        this.setProgressText(Sextante.getText((String)"Iteration") + " 1");
        do {
            features = newFeatures;
            newFeatures = this.joinLines(features);
            this.setProgressText(Sextante.getText((String)"Iteration") + " " + Integer.toString(++i) + "(" + Integer.toString(features.length - newFeatures.length) + " " + Sextante.getText((String)"lines_joined"));
        } while (newFeatures.length != features.length && !this.m_Task.isCanceled());
        IVectorLayer out = this.getNewVectorLayer(RESULT, layerIn.getName(), 1, layerIn.getFieldTypes(), layerIn.getFieldNames());
        for (IFeature element : features) {
            out.addFeature(element);
        }
        return !this.m_Task.isCanceled();
    }

    private IFeature[] joinLines(IFeature[] features) {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Object> newFeatures = new ArrayList<Object>();
        STRtree tree = new STRtree();
        BitSet bitset = new BitSet(features.length);
        for (int i = 0; i < features.length; ++i) {
            Envelope envelope = features[i].getGeometry().getEnvelopeInternal();
            tree.insert(envelope, (Object)new Integer(i));
        }
        for (int i = 0; i < features.length; ++i) {
            if (bitset.get(i)) continue;
            Geometry geom = features[i].getGeometry();
            Coordinate[] coords = geom.getCoordinates();
            Envelope envelope = features[i].getGeometry().getEnvelopeInternal();
            envelope.expandBy(this.m_dTolerance);
            List geoms = tree.query(envelope);
            boolean bFound = false;
            bitset.set(i);
            for (int j = 0; j < geoms.size(); ++j) {
                FeatureImpl newFeature;
                Coordinate[] newCoords;
                int idx = (Integer)geoms.get(j);
                if (i == idx || bitset.get(idx)) continue;
                Geometry geom2 = features[idx].getGeometry();
                Coordinate[] coords2 = geom2.getCoordinates();
                if (coords2[0].distance(coords[coords.length - 1]) < this.m_dTolerance) {
                    newCoords = new Coordinate[coords.length + coords2.length];
                    System.arraycopy(coords, 0, newCoords, 0, coords.length);
                    System.arraycopy(coords2, 0, newCoords, coords.length, coords2.length);
                    newFeature = new FeatureImpl((Geometry)gf.createLineString(newCoords), features[i].getRecord().getValues());
                    newFeatures.add(newFeature);
                    newCoords = null;
                    bFound = true;
                    bitset.set(idx);
                    break;
                }
                if (coords2[coords2.length - 1].distance(coords[0]) < this.m_dTolerance) {
                    newCoords = new Coordinate[coords.length + coords2.length];
                    System.arraycopy(coords2, 0, newCoords, 0, coords2.length);
                    System.arraycopy(coords, 0, newCoords, coords2.length, coords.length);
                    newFeature = new FeatureImpl((Geometry)gf.createLineString(newCoords), features[i].getRecord().getValues());
                    newFeatures.add(newFeature);
                    newCoords = null;
                    bFound = true;
                    bitset.set(idx);
                    break;
                }
                if (coords2[0].distance(coords[0]) < this.m_dTolerance) {
                    newCoords = new Coordinate[coords.length + coords2.length];
                    for (int k = 0; k < coords.length; ++k) {
                        newCoords[k] = coords[coords.length - 1 - k];
                    }
                    System.arraycopy(coords2, 0, newCoords, coords.length, coords2.length);
                    newFeature = new FeatureImpl((Geometry)gf.createLineString(newCoords), features[i].getRecord().getValues());
                    newFeatures.add(newFeature);
                    newCoords = null;
                    bFound = true;
                    bitset.set(idx);
                    break;
                }
                if (!(coords2[coords2.length - 1].distance(coords[coords.length - 1]) < this.m_dTolerance)) continue;
                newCoords = new Coordinate[coords.length + coords2.length];
                System.arraycopy(coords, 0, newCoords, 0, coords.length);
                for (int k = 0; k < coords2.length; ++k) {
                    newCoords[k + coords.length] = coords2[coords2.length - 1 - k];
                }
                newFeature = new FeatureImpl((Geometry)gf.createLineString(newCoords), features[i].getRecord().getValues());
                newFeatures.add(newFeature);
                newCoords = null;
                bFound = true;
                bitset.set(idx);
                break;
            }
            if (bFound) continue;
            newFeatures.add(features[i]);
            System.out.println(i + " " + coords.length);
        }
        System.gc();
        return newFeatures.toArray(new IFeature[0]);
    }
}

