/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tridimensional.profile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.Grid3DCell;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;

public class Profile3DAlgorithm
extends GeoAlgorithm {
    public static final String LINE = "LINE";
    public static final String RASTER_LAYER = "RASTER_LAYER";
    public static final String PROFILEPOINTS = "PROFILEPOINTS";
    public static final String GRAPH = "GRAPH";
    private I3DRasterLayer m_RasterLayer;
    private XYDataset dataset;
    private IVectorLayer m_Profile;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"3D_Profile"));
        this.setGroup(Sextante.getText((String)"3D"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInput3DRasterLayer(RASTER_LAYER, Sextante.getText((String)"3D_Raster_Layer"), true);
            this.m_Parameters.addInputVectorLayer(LINE, Sextante.getText((String)"Profile_line"), 1, true);
            this.addOutputVectorLayer(PROFILEPOINTS, Sextante.getText((String)"Profile_[points]"), 0);
            this.addOutputChart(GRAPH, Sextante.getText((String)"Profile"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINE);
        this.m_RasterLayer = this.m_Parameters.getParameterValueAs3DRasterLayer(RASTER_LAYER);
        if (lines.getShapesCount() == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Zero_lines_in_layer"));
        }
        String[] sFieldNames = new String[]{"X", "Y", "Z", this.m_RasterLayer.getName()};
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class};
        this.m_Profile = this.getNewVectorLayer(PROFILEPOINTS, Sextante.getText((String)"Profile_[points]"), 0, types, sFieldNames);
        IFeatureIterator iterator = lines.iterator();
        Geometry line = iterator.next().getGeometry().getGeometryN(0);
        this.processLine(line);
        iterator.close();
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel jPanelChart = new ChartPanel(chart);
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.addOutputChart(GRAPH, Sextante.getText((String)"Profile"), jPanelChart);
        return !this.m_Task.isCanceled();
    }

    private void processLine(Geometry line) {
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1 && this.setProgress(i, coords.length - 1); ++i) {
            this.processSegment(coords[i], coords[i + 1]);
        }
    }

    private void processSegment(Coordinate coord, Coordinate coord2) {
        GeometryFactory gf = new GeometryFactory();
        AnalysisExtent extent = this.m_RasterLayer.getLayerExtent();
        Grid3DCell cell = extent.getGridCoordsFromWorldCoords(coord.x, coord.y, coord.z);
        int x1 = cell.getX();
        int y1 = cell.getY();
        int z1 = cell.getZ();
        Grid3DCell cell2 = extent.getGridCoordsFromWorldCoords(coord2.x, coord2.y, coord2.z);
        int x2 = cell2.getX();
        int y2 = cell2.getY();
        int z2 = cell2.getZ();
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int ax = Math.abs(dx) * 2;
        int ay = Math.abs(dy) * 2;
        int az = Math.abs(dz) * 2;
        int sx = (int)Math.signum(dx);
        int sy = (int)Math.signum(dy);
        int sz = (int)Math.signum(dz);
        int x = x1;
        int y = y1;
        int z = z1;
        int idx = 1;
        if (ax >= Math.max(ay, az)) {
            double yd = ay - ax / 2;
            double zd = az - ax / 2;
            while (true) {
                Coordinate newCoord = extent.getWorldCoordsFromGridCoords(x, y, z);
                double dValue = this.m_RasterLayer.getCellValueAsDouble(x, y, z);
                if (!this.m_RasterLayer.isNoDataValue(dValue)) {
                    Point pt = gf.createPoint(newCoord);
                    this.m_Profile.addFeature((Geometry)pt, new Object[]{new Double(x), new Double(y), new Double(z), new Double(dValue)});
                }
                ++idx;
                if (x != x2) {
                    if (yd >= 0.0) {
                        y += sy;
                        yd -= (double)ax;
                    }
                    if (zd >= 0.0) {
                        z += sz;
                        zd -= (double)ax;
                    }
                    x += sx;
                    yd += (double)ay;
                    zd += (double)az;
                    continue;
                }
                break;
            }
        } else if (ay >= Math.max(ax, az)) {
            double xd = ax - ay / 2;
            double zd = az - ay / 2;
            while (true) {
                Coordinate newCoord = extent.getWorldCoordsFromGridCoords(x, y, z);
                double dValue = this.m_RasterLayer.getCellValueAsDouble(x, y, z);
                if (!this.m_RasterLayer.isNoDataValue(dValue)) {
                    Point pt = gf.createPoint(newCoord);
                    this.m_Profile.addFeature((Geometry)pt, new Object[]{new Double(x), new Double(y), new Double(z), new Double(dValue)});
                }
                ++idx;
                if (y != y2) {
                    if (xd >= 0.0) {
                        x += sx;
                        xd -= (double)ay;
                    }
                    if (zd >= 0.0) {
                        z += sz;
                        zd -= (double)ay;
                    }
                    y += sy;
                    xd += (double)ax;
                    zd += (double)az;
                    continue;
                }
                break;
            }
        } else if (az >= Math.max(ax, ay)) {
            double xd = ax - az / 2;
            double yd = ay - az / 2;
            while (true) {
                Coordinate newCoord = extent.getWorldCoordsFromGridCoords(x, y, z);
                double dValue = this.m_RasterLayer.getCellValueAsDouble(x, y, z);
                if (!this.m_RasterLayer.isNoDataValue(dValue)) {
                    Point pt = gf.createPoint(newCoord);
                    this.m_Profile.addFeature((Geometry)pt, new Object[]{new Double(x), new Double(y), new Double(z), new Double(dValue)});
                }
                ++idx;
                if (z == z2) break;
                if (xd >= 0.0) {
                    x += sx;
                    xd -= (double)az;
                }
                if (yd >= 0.0) {
                    y += sy;
                    yd -= (double)az;
                }
                z += sz;
                xd += (double)ax;
                yd += (double)ay;
            }
        }
    }
}

