/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.clip;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.List;

public class ClipAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String CLIPLAYER = "CLIPLAYER";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        IVectorLayer layerClip = this.m_Parameters.getParameterValueAsVectorLayer(CLIPLAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            layerClip.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        STRtree tree = this.buildClipTree(layerClip);
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Clipped_layer"), layerIn.getShapeType(), layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int i = 0;
        int iShapeCount = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry g = this.clipGeometry(feature.getGeometry(), tree);
            if (g != null) {
                this.m_Output.addFeature(g, feature.getRecord().getValues());
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Clip"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer_to_clip"), -1, true);
            this.m_Parameters.addInputVectorLayer(CLIPLAYER, Sextante.getText((String)"Clipping_layer"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Clipped_Layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public Geometry clipGeometry(Geometry g, STRtree tree) throws GeoAlgorithmExecutionException {
        if (g == null) {
            return null;
        }
        Envelope env = g.getEnvelopeInternal();
        if (env == null) {
            return null;
        }
        List candidates = tree.query(env);
        Geometry clipGeometry = null;
        Geometry result = g;
        boolean intersected = false;
        if (candidates == null || candidates.size() == 0) {
            return null;
        }
        try {
            for (PreparedGeometry pg : candidates) {
                if (!pg.intersects(result)) continue;
                intersected = true;
                clipGeometry = pg.getGeometry();
                result = clipGeometry.intersection(result);
            }
            if (!intersected) {
                return null;
            }
            if (result.getNumGeometries() == 0) {
                return null;
            }
            return result;
        }
        catch (TopologyException e) {
            if (!g.isValid()) {
                throw new GeoAlgorithmExecutionException("Wrong input geometry");
            }
            if (!clipGeometry.isValid()) {
                throw new GeoAlgorithmExecutionException("Wrong clipping geometry");
            }
            return null;
        }
    }

    private STRtree buildClipTree(IVectorLayer layer) throws IteratorException {
        STRtree tree = new STRtree();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            PreparedGeometry pg = PreparedGeometryFactory.prepare((Geometry)geom);
            tree.insert(pg.getGeometry().getEnvelopeInternal(), (Object)pg);
        }
        iter.close();
        return tree;
    }
}

