/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.generateRoutes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;
import java.util.Collections;

public class GenerateRoutesAlgorithm
extends GeoAlgorithm {
    public static final String ROUTE = "ROUTE";
    public static final String NROUTES = "NROUTES";
    public static final String METHOD = "METHOD";
    public static final String SINUOSITY = "SINUOSITY";
    public static final String USESINUOSITY = "USESINUOSITY";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Routes;
    private ArrayList m_X;
    private ArrayList m_Y;
    private int m_iNewRoutes;
    private double m_dInitX;
    private double m_dInitY;
    private double m_dSinuosity;
    private double m_dFinalX;
    private double m_dFinalY;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Generate_alternative_routes"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(ROUTE, Sextante.getText((String)"Original_route"), 1, true);
            this.m_Parameters.addNumericalValue(NROUTES, Sextante.getText((String)"Number_of_new_routes"), 1, 10.0, 1.0, 2.147483647E9);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), new String[]{Sextante.getText((String)"Constrained_brownian_motion"), Sextante.getText((String)"Recombination")});
            this.m_Parameters.addNumericalValue(SINUOSITY, Sextante.getText((String)"Sinuosity"), 2, 1.3, 1.0, 10.0);
            this.m_Parameters.addBoolean(USESINUOSITY, Sextante.getText((String)"Use_base_route_sinuosity"), false);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Routes"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double y;
        double x;
        double dRouteDist = 0.0;
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(ROUTE);
        this.m_iNewRoutes = this.m_Parameters.getParameterValueAsInt(NROUTES);
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        boolean bUseRouteSinuosity = this.m_Parameters.getParameterValueAsBoolean(USESINUOSITY);
        this.m_dSinuosity = this.m_Parameters.getParameterValueAsDouble(SINUOSITY);
        int iShapeCount = lines.getShapesCount();
        if (iShapeCount == 0) {
            throw new GeoAlgorithmExecutionException("zero lines in layer");
        }
        this.m_Routes = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Alternative_routes"), 1, new Class[]{Integer.class}, new String[]{"ID"});
        IFeatureIterator iter = lines.iterator();
        IFeature feature = iter.next();
        Geometry geom = feature.getGeometry();
        Geometry line = geom.getGeometryN(0);
        Coordinate[] coords = line.getCoordinates();
        this.m_X = new ArrayList();
        this.m_Y = new ArrayList();
        this.m_dInitX = x = coords[0].x;
        this.m_dInitY = y = coords[0].y;
        for (int i = 1; i < coords.length; ++i) {
            double dDifX = coords[i].x - x;
            double dDifY = coords[i].y - y;
            dRouteDist += Math.sqrt(dDifX * dDifX + dDifY * dDifY);
            this.m_X.add(new Double(dDifX));
            this.m_Y.add(new Double(dDifY));
            x = coords[i].x;
            y = coords[i].y;
        }
        this.m_dFinalX = x;
        this.m_dFinalY = y;
        double dStraightDist = Math.sqrt(Math.pow(this.m_dFinalX - this.m_dInitX, 2.0) + Math.pow(this.m_dFinalY - this.m_dInitY, 2.0));
        if (bUseRouteSinuosity) {
            this.m_dSinuosity = dRouteDist / dStraightDist;
        }
        if (iMethod == 0) {
            this.generateRoutesBrownian();
        } else {
            this.generateRoutesRecombine();
        }
        return !this.m_Task.isCanceled();
    }

    private void generateRoutesRecombine() {
        Object[] value = new Object[1];
        for (int i = 0; i < this.m_iNewRoutes && this.setProgress(i, this.m_iNewRoutes); ++i) {
            Collections.shuffle(this.m_X);
            Collections.shuffle(this.m_Y);
            Coordinate[] coords = new Coordinate[this.m_X.size() + 1];
            double dLastX = this.m_dInitX;
            double dLastY = this.m_dInitY;
            coords[0] = new Coordinate(this.m_dInitX, this.m_dInitY);
            for (int j = 0; j < this.m_X.size(); ++j) {
                double dX = dLastX + (Double)this.m_X.get(j);
                double dY = dLastY + (Double)this.m_Y.get(j);
                coords[j + 1] = new Coordinate(dX, dY);
                dLastX = dX;
                dLastY = dY;
            }
            value[0] = new Integer(i);
            GeometryFactory gf = new GeometryFactory();
            LineString geom = gf.createLineString(coords);
            this.m_Routes.addFeature((Geometry)geom, value);
        }
    }

    private void generateRoutesBrownian() {
        int SEGMENTS = 50;
        double dPreviousDist = 0.0;
        double dTotalXDif = this.m_dFinalX - this.m_dInitX;
        double dTotalYDif = this.m_dFinalY - this.m_dInitY;
        double dTotalDist = Math.sqrt(dTotalXDif * dTotalXDif + dTotalYDif * dTotalYDif) * this.m_dSinuosity;
        Object[] value = new Object[1];
        for (int iRoute = 0; iRoute < this.m_iNewRoutes && this.setProgress(iRoute, this.m_iNewRoutes); ++iRoute) {
            Coordinate[] coords = new Coordinate[51];
            coords[0] = new Coordinate(this.m_dInitX, this.m_dInitY);
            double dLastX = this.m_dInitX;
            double dLastY = this.m_dInitY;
            dPreviousDist = 0.0;
            for (int i = 1; i < 50; ++i) {
                double dY;
                double dX;
                double dDist;
                double dMaxDist = dTotalDist - dPreviousDist;
                double dMaxSegmentDist = dMaxDist / (double)(50 - i);
                dMaxDist /= this.m_dSinuosity;
                int iIter = 0;
                do {
                    dDist = Math.random() * dMaxSegmentDist;
                    double dAngle = Math.random() * Math.PI * 2.0;
                    dX = dLastX + dDist * Math.cos(dAngle);
                    dY = dLastY + dDist * Math.sin(dAngle);
                } while ((dDist = Math.sqrt(Math.pow(this.m_dFinalX - dX, 2.0) + Math.pow(this.m_dFinalY - dY, 2.0))) > dMaxDist && ++iIter < 1000);
                if (iIter == 1000) {
                    dX = dLastX + (this.m_dFinalX - dLastX) * (dMaxSegmentDist / dMaxDist);
                    dY = dLastY + (this.m_dFinalY - dLastY) * (dMaxSegmentDist / dMaxDist);
                }
                dPreviousDist += Math.sqrt(Math.pow(dLastX - dX, 2.0) + Math.pow(dLastY - dY, 2.0));
                coords[i] = new Coordinate(dX, dY);
                dLastX = dX;
                dLastY = dY;
            }
            coords[i] = new Coordinate(this.m_dFinalX, this.m_dFinalY);
            value[0] = new Integer(iRoute);
            GeometryFactory gf = new GeometryFactory();
            LineString geom = gf.createLineString(coords);
            this.m_Routes.addFeature((Geometry)geom, value);
        }
    }
}

