/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.graticuleBuilder;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class GraticuleBuilderAlgorithm
extends GeoAlgorithm {
    private static final int TYPE_RECTANGLES = 0;
    private static final int TYPE_LINES = 1;
    private static final int TYPE_POINTS = 2;
    public static final String GRATICULE = "GRATICULE";
    public static final String TYPE = "TYPE";
    public static final String INTERVALY = "INTERVALY";
    public static final String INTERVALX = "INTERVALX";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Create_graticule"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        String[] sOptions = new String[]{Sextante.getText((String)"Rectangles"), Sextante.getText((String)"Lines"), Sextante.getText((String)"Points")};
        try {
            this.m_Parameters.addNumericalValue(INTERVALX, Sextante.getText((String)"X_interval"), 1.0, 2);
            this.m_Parameters.addNumericalValue(INTERVALY, Sextante.getText((String)"Y_interval"), 1.0, 2);
            this.m_Parameters.addSelection(TYPE, Sextante.getText((String)"Type"), sOptions);
            this.addOutputVectorLayer(GRATICULE, Sextante.getText((String)"Graticule"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iShapeType;
        int i = 0;
        int iID = 0;
        String[] sNames = new String[]{"ID", "X", "Y", "BORDER"};
        Class[] types = new Class[]{Integer.class, Double.class, Double.class, Integer.class};
        double dXMax = this.m_AnalysisExtent.getXMax();
        double dXMin = this.m_AnalysisExtent.getXMin();
        double dYMax = this.m_AnalysisExtent.getYMax();
        double dYMin = this.m_AnalysisExtent.getYMin();
        double dIntervalX = this.m_Parameters.getParameterValueAsDouble(INTERVALX);
        double dIntervalY = this.m_Parameters.getParameterValueAsDouble(INTERVALY);
        int iType = this.m_Parameters.getParameterValueAsInt(TYPE);
        int iCountX = (int)((dXMax - dXMin) / dIntervalX);
        int iCountY = (int)((dYMax - dYMin) / dIntervalY);
        switch (iType) {
            case 0: {
                iShapeType = 2;
                break;
            }
            case 1: {
                iShapeType = 1;
                iCountX *= 2;
                break;
            }
            default: {
                iShapeType = 0;
            }
        }
        IVectorLayer output = this.getNewVectorLayer(GRATICULE, Sextante.getText((String)"Graticule"), iShapeType, types, sNames);
        Object[] value = new Object[4];
        GeometryFactory gf = new GeometryFactory();
        switch (iType) {
            case 0: {
                double x = dXMin;
                while (x < dXMax - dIntervalX & this.setProgress(i++, iCountX)) {
                    for (double y = dYMin; y < dYMax - dIntervalY; y += dIntervalY) {
                        Coordinate[] coords = new Coordinate[]{new Coordinate(x, y), new Coordinate(x, y + dIntervalY), new Coordinate(x + dIntervalX, y + dIntervalY), new Coordinate(x + dIntervalX, y), new Coordinate(x, y)};
                        value[0] = new Integer(iID++);
                        value[1] = new Double(x);
                        value[2] = new Double(y);
                        value[3] = x == dXMin || x + dIntervalX >= dXMax - dIntervalX || y == dYMin || y + dIntervalY >= dYMax - dIntervalY ? new Integer(1) : new Integer(0);
                        LinearRing ring = gf.createLinearRing(coords);
                        Polygon geom = gf.createPolygon(ring, null);
                        output.addFeature((Geometry)geom, value);
                    }
                    x += dIntervalX;
                }
                break;
            }
            case 1: {
                LineString line;
                Coordinate[] coords;
                for (double x = dXMin; x <= dXMax && this.setProgress(i++, iCountX); x += dIntervalX) {
                    coords = new Coordinate[]{new Coordinate(x, dYMin), new Coordinate(x, dYMax)};
                    line = gf.createLineString(coords);
                    value[0] = new Integer(iID++);
                    value[1] = new Double(x);
                    value[2] = new Double(dYMin);
                    value[3] = x == dXMin || x + dIntervalX > dXMax - dIntervalX ? new Integer(1) : new Integer(0);
                    output.addFeature((Geometry)line, value);
                }
                i = 0;
                for (double y = dYMin; y <= dYMax && this.setProgress(i++, iCountY); y += dIntervalY) {
                    coords = new Coordinate[]{new Coordinate(dXMin, y), new Coordinate(dXMax, y)};
                    line = gf.createLineString(coords);
                    value[0] = new Integer(iID++);
                    value[1] = new Double(dXMin);
                    value[2] = new Double(y);
                    value[3] = y == dYMin || y + dIntervalY > dYMax - dIntervalY ? new Integer(1) : new Integer(0);
                    output.addFeature((Geometry)line, value);
                }
                break;
            }
            case 2: {
                for (double x = dXMin; x <= dXMax && this.setProgress(i++, iCountX); x += dIntervalX) {
                    for (double y = dYMin; y <= dYMax; y += dIntervalY) {
                        Point point = gf.createPoint(new Coordinate(x, y));
                        value[0] = new Integer(iID++);
                        value[1] = new Double(x);
                        value[2] = new Double(y);
                        value[3] = x == dXMin || x + dIntervalX > dXMax || y == dYMin || y + dIntervalY > dYMax ? new Integer(1) : new Integer(0);
                        output.addFeature((Geometry)point, value);
                    }
                }
                break;
            }
        }
        return !this.m_Task.isCanceled();
    }
}

