/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.merge;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class MergeAlgorithm
extends GeoAlgorithm {
    public static final String LAYERMAIN = "LAYERMAIN";
    public static final String LAYERS = "LAYERS";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;
    private IVectorLayer layerMain;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.layerMain = this.m_Parameters.getParameterValueAsVectorLayer(LAYERMAIN);
        ArrayList layers = this.m_Parameters.getParameterValueAsArrayList(LAYERS);
        if (!this.m_bIsAutoExtent) {
            this.layerMain.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), this.layerMain.getShapeType(), this.layerMain.getFieldTypes(), this.layerMain.getFieldNames());
        this.merge(this.layerMain);
        for (int i = 0; i < layers.size() && !this.m_Task.isCanceled(); ++i) {
            IVectorLayer vect = (IVectorLayer)layers.get(i);
            vect.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.merge(vect);
        }
        return !this.m_Task.isCanceled();
    }

    private void merge(IVectorLayer vect) {
        int i = 0;
        try {
            if (vect.getShapeType() == this.layerMain.getShapeType()) {
                int iShapeCount = vect.getShapesCount();
                int iFieldsMain = this.layerMain.getFieldCount();
                Class[] types = this.layerMain.getFieldTypes();
                int iFieldsMerge = vect.getFieldCount();
                IFeatureIterator iter = vect.iterator();
                while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
                    IFeature feature = iter.next();
                    Object[] values = new Object[iFieldsMain];
                    Geometry shape = feature.getGeometry();
                    for (int j = 0; j < values.length; ++j) {
                        Class valueTypeMain = types[j];
                        String sFieldNameMain = this.layerMain.getFieldName(j);
                        this.initializeDefaultValues(types, values);
                        for (int k = 0; k < iFieldsMerge; ++k) {
                            Class valueTypeMerge = vect.getFieldType(k);
                            String sFieldNameMerge = vect.getFieldName(k);
                            if (!sFieldNameMerge.equalsIgnoreCase(sFieldNameMain) || !valueTypeMain.equals(valueTypeMerge)) continue;
                            values[j] = feature.getRecord().getValue(k);
                        }
                    }
                    this.m_Output.addFeature(shape, values);
                    ++i;
                }
                iter.close();
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Merge"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYERMAIN, Sextante.getText((String)"Main_layer"), -1, true);
            this.m_Parameters.addMultipleInput(LAYERS, Sextante.getText((String)"Additional_layers"), 5, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

