/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.pointCoordinates;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.shapesTools.ShapesTools;

public class pointCoordinatesAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String GRIDS = "GRIDS";
    public static final String INTERPOLATE = "INTERPOLATE";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Add_coordinates_to_points"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Points_layer"), 0, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Points"), 0, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iProgress = 0;
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iShapeCount = this.m_Layer.getShapesCount();
        Object[][] values = new Double[2][iShapeCount];
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(iProgress, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate[] coords = geom.getCoordinates();
            values[0][iProgress] = new Double(coords[0].x);
            values[1][iProgress] = new Double(coords[0].y);
            ++iProgress;
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        String[] sNames = new String[]{"X", "Y"};
        Class[] types = new Class[]{Double.class, Double.class};
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setDescription(this.m_Layer.getName());
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)this.m_Layer, (IOutputChannel)channel, (String[])sNames, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return !this.m_Task.isCanceled();
    }
}

