/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.splitLinesWithPoints;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.vectorTools.splitLinesWithPoints.NearestNeighbourFinder;
import es.unex.sextante.vectorTools.splitLinesWithPoints.PtAndAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public class SplitLinesWithPointsAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String METHOD = "METHOD";
    public static final String TOLERANCE = "TOLERANCE";
    public static final String LINES = "LINES";
    public static final String POINTS = "POINTS";
    private IVectorLayer m_Points;
    private IVectorLayer m_Lines;
    private IVectorLayer m_Output;
    private double m_dTolerance;
    private int m_iMethod;
    private ArrayList m_Path;
    private Object[] m_LastValue;
    private BitSet m_UsedPoints;
    private NearestNeighbourFinder m_NNF;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Split_lines_with_points_layer"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        String[] sOptions = new String[]{Sextante.getText((String)"Add_data_before_point"), Sextante.getText((String)"Add_data_after_point")};
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Capa_de_lineas"), 1, true);
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points_layer"), 0, true);
            this.m_Parameters.addNumericalValue(TOLERANCE, Sextante.getText((String)"Tolerance"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sOptions);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Splitted_lines"), 1);
        }
        catch (RepeatedParameterNameException repeatedParameterNameException) {
            // empty catch block
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        this.m_Lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_dTolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE);
        if (!this.m_bIsAutoExtent) {
            this.m_Points.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_Lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] types = new Class[this.m_Lines.getFieldCount() + this.m_Points.getFieldCount()];
        String[] sFields = new String[this.m_Lines.getFieldCount() + this.m_Points.getFieldCount()];
        for (i = 0; i < this.m_Lines.getFieldCount(); ++i) {
            types[i] = this.m_Lines.getFieldType(i);
            sFields[i] = this.m_Lines.getFieldName(i);
        }
        for (i = 0; i < this.m_Points.getFieldCount(); ++i) {
            sFields[i + this.m_Lines.getFieldCount()] = this.m_Points.getFieldName(i);
            types[i + this.m_Lines.getFieldCount()] = this.m_Points.getFieldType(i);
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Splitted_lines"), this.m_Lines.getShapeType(), types, sFields);
        this.m_NNF = new NearestNeighbourFinder(this.m_Points, this.m_Task);
        this.m_UsedPoints = new BitSet(this.m_Points.getShapesCount());
        int iShapeCount = this.m_Lines.getShapesCount();
        i = 0;
        IFeatureIterator iter = this.m_Lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            this.splitLine(feature.getGeometry(), feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void splitLine(Geometry line, Object[] row) {
        Object[] nullValue = new Object[this.m_Points.getFieldCount()];
        for (int i = 0; i < nullValue.length; ++i) {
            try {
                Class c = this.m_Points.getFieldType(i);
                nullValue[i] = c.newInstance();
                continue;
            }
            catch (Exception c) {
                // empty catch block
            }
        }
        this.m_LastValue = nullValue;
        this.m_Path = new ArrayList();
        for (int i = 0; i < line.getNumGeometries(); ++i) {
            try {
                int j;
                Geometry geom = line.getGeometryN(i);
                Coordinate[] coords = geom.getCoordinates();
                this.m_Path.add(coords[0]);
                LineSegment segment = null;
                for (int j2 = 0; j2 < coords.length - 1; ++j2) {
                    segment = new LineSegment(coords[j2], coords[j2 + 1]);
                    this.splitSegment(segment, row);
                }
                if (segment != null) {
                    this.m_Path.add(segment.p1);
                }
                Object[] values = new Object[row.length + this.m_Points.getFieldCount()];
                for (j = 0; j < row.length; ++j) {
                    values[j] = row[j];
                }
                if (this.m_iMethod == 0) {
                    for (j = 0; j < this.m_Points.getFieldCount(); ++j) {
                        values[row.length + j] = nullValue[j];
                    }
                } else {
                    for (j = 0; j < this.m_Points.getFieldCount(); ++j) {
                        values[row.length + j] = this.m_LastValue[j];
                    }
                }
                this.addCurrentGeometry(values);
                continue;
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    private void splitSegment(LineSegment seg, Object[] row) throws Exception {
        int i;
        ArrayList<CoordinateAndDist> closePoints = new ArrayList<CoordinateAndDist>();
        PtAndAttributes[] pts = this.m_NNF.getClosestPoints(seg, this.m_dTolerance);
        for (int i2 = 0; i2 < pts.length; ++i2) {
            Coordinate c;
            double dDist;
            if (this.m_UsedPoints.get(pts[i2].id) || !((dDist = seg.distance(c = new Coordinate(pts[i2].x, pts[i2].y))) < this.m_dTolerance)) continue;
            Coordinate closest = seg.closestPoint(c);
            double dX = closest.x - seg.p0.x;
            double dY = closest.y - seg.p0.y;
            dDist = dX * dX + dY * dY;
            closePoints.add(new CoordinateAndDist(closest, dDist, pts[i2].attrs));
            this.m_UsedPoints.set(pts[i2].id);
        }
        Object[] ptArray = new CoordinateAndDist[closePoints.size()];
        for (i = 0; i < closePoints.size(); ++i) {
            ptArray[i] = (CoordinateAndDist)closePoints.get(i);
        }
        Arrays.sort(ptArray);
        for (i = 0; i < ptArray.length; ++i) {
            int j;
            Object[] values = new Object[row.length + this.m_Points.getFieldCount()];
            for (j = 0; j < row.length; ++j) {
                values[j] = row[j];
            }
            if (this.m_iMethod == 0) {
                for (j = 0; j < this.m_Points.getFieldCount(); ++j) {
                    values[row.length + j] = ((CoordinateAndDist)ptArray[i]).val[j];
                }
            } else {
                for (j = 0; j < this.m_Points.getFieldCount(); ++j) {
                    values[row.length + j] = this.m_LastValue[j];
                }
                this.m_LastValue = ((CoordinateAndDist)ptArray[i]).val;
            }
            this.m_Path.add(((CoordinateAndDist)ptArray[i]).coord);
            this.addCurrentGeometry(values);
            this.m_Path = new ArrayList();
            this.m_Path.add(((CoordinateAndDist)ptArray[i]).coord);
        }
        this.m_Path.add(seg.p1);
    }

    private void addCurrentGeometry(Object[] values) {
        if (this.m_Path.size() != 0) {
            Coordinate[] coords = new Coordinate[this.m_Path.size()];
            for (int i = 0; i < coords.length; ++i) {
                Coordinate c;
                coords[i] = c = (Coordinate)this.m_Path.get(i);
            }
            GeometryFactory gf = new GeometryFactory();
            this.m_Output.addFeature((Geometry)gf.createLineString(coords), values);
        }
    }

    private class CoordinateAndDist
    implements Comparable {
        private final Coordinate coord;
        private final double dist;
        private final Object[] val;

        CoordinateAndDist(Coordinate c, double d, Object[] v) {
            this.coord = c;
            this.dist = d;
            this.val = v;
        }

        public int compareTo(Object ob) {
            if (!(ob instanceof CoordinateAndDist)) {
                throw new ClassCastException();
            }
            double dist2 = ((CoordinateAndDist)ob).dist;
            return (int)Math.signum(this.dist - dist2);
        }
    }
}

