/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.splitPolylinesAtNodes;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class SplitPolylinesAtNodesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LINES = "LINES";
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Split_polylines_at_nodes"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Lines"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), 1, lines.getFieldTypes(), lines.getFieldNames());
        int i = 0;
        int iShapeCount = lines.getShapesCount();
        IFeatureIterator iter = lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry line = geom.getGeometryN(j);
                this.addLine(line, feature.getRecord().getValues());
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void addLine(Geometry line, Object[] attributes) {
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coords = line.getCoordinates();
        Coordinate[] segmentCoords = new Coordinate[2];
        for (int i = 0; i < coords.length - 1; ++i) {
            segmentCoords[0] = new Coordinate(coords[i].x, coords[i].y);
            segmentCoords[1] = new Coordinate(coords[i + 1].x, coords[i + 1].y);
            this.m_Output.addFeature((Geometry)gf.createLineString(segmentCoords), attributes);
        }
    }
}

