/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.transform;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.gvsig.tools.exception.BaseException;

public class TransformAlgorithm
extends GeoAlgorithm {
    public static final String DISTANCEX = "DISTANCEX";
    public static final String DISTANCEY = "DISTANCEY";
    public static final String ANCHORX = "ANCHORX";
    public static final String ANCHORY = "ANCHORY";
    public static final String ANGLE = "ANGLE";
    public static final String SCALEX = "SCALEX";
    public static final String LAYER = "LAYER";
    public static final String SCALEY = "SCALEY";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;
    private double dDistanceX;
    private double dDistanceY;
    private double dAnchorX;
    private double dAnchorY;
    private double dAngle;
    private double dScaleX;
    private double dScaleY;
    IVectorLayer layerIn;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int subtype;
        this.dDistanceX = this.m_Parameters.getParameterValueAsDouble(DISTANCEX);
        this.dDistanceY = this.m_Parameters.getParameterValueAsDouble(DISTANCEY);
        this.dAnchorX = this.m_Parameters.getParameterValueAsDouble(ANCHORX);
        this.dAnchorY = this.m_Parameters.getParameterValueAsDouble(ANCHORY);
        this.dAngle = this.m_Parameters.getParameterValueAsDouble(ANGLE);
        this.dScaleX = this.m_Parameters.getParameterValueAsDouble(SCALEX);
        this.dScaleY = this.m_Parameters.getParameterValueAsDouble(SCALEY);
        this.layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        try {
            subtype = this.layerIn.getSubType();
        }
        catch (BaseException e) {
            subtype = 4;
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Capa_transformada"), this.layerIn.getShapeType(), this.layerIn.getFieldTypes(), this.layerIn.getFieldNames(), subtype);
        AffineTransformation at = new AffineTransformation();
        at.compose(AffineTransformation.translationInstance((double)(-this.dAnchorX), (double)(-this.dAnchorY)));
        at.compose(AffineTransformation.rotationInstance((double)Math.toRadians(this.dAngle)));
        at.compose(AffineTransformation.translationInstance((double)this.dAnchorX, (double)this.dAnchorY));
        at.compose(AffineTransformation.scaleInstance((double)this.dScaleX, (double)this.dScaleY));
        at.compose(AffineTransformation.translationInstance((double)this.dDistanceX, (double)this.dDistanceY));
        IFeatureIterator iter = this.layerIn.iterator();
        int i = 0;
        int iShapeCount = this.layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = (Geometry)feature.getGeometry().clone();
            geom.apply((CoordinateSequenceFilter)at);
            this.m_Output.addFeature(geom, feature.getRecord().getValues());
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Transform"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_layer"), -1, true);
            this.m_Parameters.addNumericalValue(DISTANCEX, Sextante.getText((String)"Translation_X"), 2, 0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(DISTANCEY, Sextante.getText((String)"Translation_Y"), 2, 0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(ANGLE, Sextante.getText((String)"Rotation_angle"), 2, 0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(SCALEX, Sextante.getText((String)"Scale_factor__X"), 2, 1.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(SCALEY, Sextante.getText((String)"Scale_Factor__Y"), 2, 1.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(ANCHORX, Sextante.getText((String)"Anchor_point_X"), 2, 0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(ANCHORY, Sextante.getText((String)"Anchor_point_Y"), 2, 0.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Capa_transformada"), -1, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

