/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.hyperlink.app.extension.AbstractHyperLinkPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowPanel
extends JPanel
implements IWindow,
ComponentListener {
    private static Logger logger = LoggerFactory.getLogger(ShowPanel.class);
    private JScrollPane jScrollPane = null;
    private WindowInfo m_ViewInfo = null;
    private AbstractHyperLinkPanel contents = null;
    private static int xpos = 0;
    private static int ypos = 0;

    public ShowPanel(AbstractHyperLinkPanel contents) {
        this.contents = contents;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
        this.getJScrollPane().setViewportView(this.contents);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
        }
        return this.jScrollPane;
    }

    public WindowInfo getWindowInfo() {
        int height;
        if (this.m_ViewInfo == null) {
            this.m_ViewInfo = new WindowInfo(39);
            URL urlContent = this.contents.getLinkTarget().getURL();
            if (urlContent != null) {
                URI uriContent = null;
                try {
                    uriContent = urlContent.toURI();
                }
                catch (URISyntaxException ex) {
                    logger.warn("Not able to convert to URI:" + urlContent.toString());
                }
                if (uriContent != null) {
                    if (uriContent.toString().startsWith("file:") && uriContent.isAbsolute()) {
                        try {
                            File file = new File(uriContent.toURL().getFile());
                            this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"Hyperlink") + " - " + file.getName());
                        }
                        catch (MalformedURLException e) {
                            this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"Hyperlink") + " - " + uriContent.toString());
                        }
                        catch (NullPointerException e) {
                            this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"Hyperlink") + " - " + uriContent.toString());
                        }
                    } else {
                        this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"Hyperlink") + " - " + uriContent.toString());
                    }
                }
            } else {
                this.m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"Hyperlink"));
            }
        }
        if ((height = (int)this.contents.getPreferredSize().getHeight() + 15) > 650) {
            height = 650;
        } else if (height < 450) {
            height = 450;
        }
        int width = (int)this.contents.getPreferredSize().getWidth() + 20;
        if (width > 800) {
            width = 800;
        } else if (width < 450) {
            width = 450;
        }
        this.m_ViewInfo.setWidth(width);
        this.m_ViewInfo.setHeight(height);
        this.m_ViewInfo.setX(xpos);
        xpos = (xpos + 20) % 270;
        this.m_ViewInfo.setY(ypos);
        ypos = (ypos + 15) % 150;
        return this.m_ViewInfo;
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public Object getWindowProfile() {
        return WindowInfo.EDITOR_PROFILE;
    }
}

