/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.txt.UniversalEncodingDetector;
import org.gvsig.fmap.dal.exception.UnsupportedEncodingException;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFieldDescriptor;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFile;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFileHeader;
import org.gvsig.tools.task.SimpleTaskStatus;

public class DBFAutodetectInputStream
extends InputStream {
    private DbaseFile dbaseFile;
    private long row;
    private int col;
    private int currentByte;
    private byte[] bytes;
    private final int[] stringColumns;
    private int maxRecords;
    private SimpleTaskStatus status;

    private DBFAutodetectInputStream(File dbfFile, int autodetectCharsetMaxRecords, SimpleTaskStatus status) throws IOException {
        try {
            this.status = status;
            this.maxRecords = autodetectCharsetMaxRecords;
            this.dbaseFile = new DbaseFile(dbfFile);
            this.row = 0L;
            this.col = 0;
            this.currentByte = -1;
            this.bytes = null;
            int numStringColumns = 0;
            int theCol = 0;
            this.dbaseFile.open();
            if (this.maxRecords < 0) {
                this.maxRecords = this.dbaseFile.getRecordCount();
            }
            status.setRangeOfValues(0L, (long)this.maxRecords);
            DbaseFileHeader header = this.dbaseFile.getHeader();
            while (theCol < header.getNumFields()) {
                DbaseFieldDescriptor type = header.getFieldDescription(theCol);
                if (type.getType() == 'C') {
                    ++numStringColumns;
                }
                ++theCol;
            }
            if (numStringColumns == 0) {
                this.row = this.dbaseFile.getRecordCount();
                this.stringColumns = null;
            } else {
                this.stringColumns = new int[numStringColumns];
                int i = 0;
                for (theCol = 0; theCol < header.getNumFields(); ++theCol) {
                    DbaseFieldDescriptor type = header.getFieldDescription(theCol);
                    if (type.getType() != 'C') continue;
                    this.stringColumns[i++] = theCol;
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Can't create autodetect dbf input stream", ex);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.status.isCancellationRequested()) {
            this.status.cancel();
            return -1;
        }
        try {
            if (this.dbaseFile == null) {
                return -1;
            }
            if (this.row >= (long)this.maxRecords) {
                return -1;
            }
            if (this.col < 0) {
                return -1;
            }
            if (this.col >= this.stringColumns.length) {
                this.col = 0;
                ++this.row;
                this.status.incrementCurrentValue();
                this.bytes = null;
            }
            if (this.bytes == null) {
                this.bytes = this.dbaseFile.getBytesFieldValue(this.row, this.stringColumns[this.col]);
                this.currentByte = 0;
            }
            byte theByte = this.bytes[this.currentByte++];
            if (this.currentByte >= this.bytes.length) {
                ++this.col;
                this.bytes = null;
            }
            return theByte;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("", ex);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.status.isCancellationRequested()) {
            this.status.cancel();
            return 0;
        }
        try {
            if (this.dbaseFile == null) {
                return 0;
            }
            if (this.row >= (long)this.maxRecords) {
                return 0;
            }
            if (this.col < 0) {
                return 0;
            }
            if (this.col >= this.stringColumns.length) {
                this.col = 0;
                ++this.row;
                this.status.incrementCurrentValue();
                this.bytes = null;
            }
            if (this.bytes == null) {
                this.bytes = this.dbaseFile.getBytesFieldValue(this.row, this.stringColumns[this.col]);
                this.currentByte = 0;
            }
            if (this.currentByte >= this.bytes.length) {
                ++this.col;
                this.bytes = null;
            }
            return 1;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("", ex);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.dbaseFile);
        this.dbaseFile = null;
    }

    public static Charset autodetectCharset(File dbfFile, int autodetectCharsetMaxRecords) throws IOException {
        return DBFAutodetectInputStream.autodetectCharset(dbfFile, autodetectCharsetMaxRecords, SimpleTaskStatus.FAKE_STATUS);
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public static Charset autodetectCharset(File dbfFile, int autodetectCharsetMaxRecords, SimpleTaskStatus status) throws IOException {
        Charset charset;
        Reader reader = null;
        DBFAutodetectInputStream is = null;
        if (status == null) {
            status = SimpleTaskStatus.FAKE_STATUS;
        }
        try {
            Charset charset2;
            is = new DBFAutodetectInputStream(dbfFile, autodetectCharsetMaxRecords, status);
            UniversalEncodingDetector detector = new UniversalEncodingDetector();
            detector.setMarkLimit(Integer.MAX_VALUE);
            charset = charset2 = detector.detect((InputStream)is, new Metadata());
        }
        catch (Exception tex) {
            try {
                throw new IOException("Cant detect encoding", tex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly((InputStream)is);
        return charset;
    }
}

