/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dbf;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadRuntimeException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.store.dbf.DBFStoreProvider;
import org.gvsig.fmap.dal.store.dbf.utils.DbaseFieldDescriptor;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.math.BigDecimalUtils;

public class DBFFeatureProvider
extends DefaultFeatureProvider {
    protected DBFStoreProvider store;
    protected boolean loading;
    protected boolean loaded;
    private final FeatureType storeFeatureType;

    public DBFFeatureProvider(DBFStoreProvider store, FeatureType providerFeatureType, FeatureType storeFeatureType) {
        super(providerFeatureType);
        this.store = store;
        this.storeFeatureType = storeFeatureType;
        this.loading = false;
        this.loaded = false;
    }

    protected void load() {
        if (this.loading || this.loaded || this.isNew()) {
            return;
        }
        this.loading = true;
        try {
            this.store.loadFeatureProviderByIndex((FeatureProvider)this);
        }
        catch (DataException e) {
            throw new ReadRuntimeException(this.getNameForMessages(), this.getOID(), (Throwable)e);
        }
        finally {
            this.loading = false;
            this.loaded = true;
        }
    }

    protected String getNameForMessages() {
        try {
            return this.store.getName();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public void set(int i, Object value) {
        this.load();
        super.set(i, value);
    }

    public void set(String name, Object value) {
        this.load();
        super.set(this.featureType.getIndex(name), value);
    }

    public Object get(int i) {
        this.load();
        return super.get(i);
    }

    public Object get(String name) {
        this.load();
        return super.get(name);
    }

    public Geometry getDefaultGeometry() {
        return null;
    }

    public Envelope getDefaultEnvelope() {
        return null;
    }

    public void setOID(Object oid) {
        this.loaded = false;
        super.setOID(oid);
    }

    public FeatureProvider getCopy() {
        this.load();
        return super.getCopy();
    }

    public void setProviderFeatureType(FeatureType featureType) {
        this.featureType = featureType;
    }

    public FeatureType getStoreFeatureType() {
        return this.storeFeatureType;
    }

    public FeatureType getProviderFeatureType() {
        return this.getType();
    }

    protected Object coerceToField(FeatureAttributeDescriptor attribute, Object value) {
        Class objectClass = attribute.getObjectClass();
        if (objectClass != null) {
            if (!objectClass.isInstance(value)) {
                try {
                    Coercion coercer = attribute.getDataType().getCoercion();
                    if (attribute.getType() == 8 && value instanceof Boolean) {
                        value = coercer.coerce(value, attribute.getCoercionContext());
                        value = StringUtils.left((String)((String)value), (int)attribute.getSize());
                    }
                    value = coercer.coerce(value, attribute.getCoercionContext());
                }
                catch (CoercionException e) {
                    throw new IllegalArgumentException("Can't convert to " + attribute.getDataType().getName() + " from '" + value.getClass().getName() + "' with value '" + value.toString() + "' and context '" + attribute.getCoercionContext() + "' to assign to '" + attribute.getName() + "'.", e);
                }
            } else {
                switch (attribute.getType()) {
                    case 19: {
                        BigDecimal d = (BigDecimal)value;
                        DbaseFieldDescriptor dbfattr = this.store.getDBFFile().getHeader().getFieldDescription(attribute.getName());
                        if (BigDecimalUtils.canFitToSize((BigDecimal)d, (int)dbfattr.getSize(), (int)dbfattr.getScale())) break;
                        throw new IllegalArgumentException("Can't assign " + value.toString() + " to '" + attribute.getName() + "'.");
                    }
                }
            }
        }
        return value;
    }
}

