/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lizardtech.io;

import es.gva.cit.jmrsid.LTIGeoCoord;
import es.gva.cit.jmrsid.LTIMetadataDatabase;
import es.gva.cit.jmrsid.LTIMetadataRecord;
import es.gva.cit.jmrsid.LTISceneBuffer;
import es.gva.cit.jmrsid.LTIUtils;
import es.gva.cit.jmrsid.MrSIDException;
import es.gva.cit.jmrsid.MrSIDImageReader;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;

public class LizardTechNative
extends MrSIDImageReader {
    static boolean WITH_OVERVIEWS = true;
    public int width = 0;
    public int height = 0;
    public double originX = 0.0;
    public double originY = 0.0;
    public String version = "";
    public LTIMetadataDatabase metadata;
    private int alpha = 0;
    protected int rBandNr = 1;
    protected int gBandNr = 2;
    protected int bBandNr = 3;
    protected byte[] bandR;
    protected byte[] bandG;
    protected byte[] bandB;
    private int dataType = 1;
    private double zoomoverview = 0.0;
    private int eSampleType;
    private int noverviews;
    public int xini;
    public int yini;
    public int anchoOver;
    public int altoOver;
    public int blocksize = 1;
    public int nbands;
    private double currentViewY = -1.0;
    private double currentViewX = 0.0;
    private int currentViewWidth = -1;
    private int currentViewHeight = -1;
    private int currentFullWidth = -1;
    private int currentFullHeight = -1;
    private int overviewFullWidth = -1;
    private int overviewFullHeight = -1;
    private double viewportScaleX = 0.0;
    private double viewportScaleY = 0.0;
    private double[] currentImageView = new double[4];
    public int[] stepArrayX = null;
    public int[] stepArrayY = null;
    public boolean isSupersampling = false;
    private String fileName = null;
    protected AffineTransform ownTransformation = null;
    protected AffineTransform externalTransformation = new AffineTransform();
    protected AffineTransform[] overviewsTransformation = null;

    public LizardTechNative(String fName) throws MrSIDException, IOException {
        super(fName);
        this.init(fName);
    }

    private void init(String fName) throws MrSIDException, IOException {
        this.initialize();
        this.fileName = fName;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.eSampleType = this.getDataType();
        this.nbands = this.getNumBands();
        this.noverviews = this.getNumLevels();
        this.overviewsTransformation = new AffineTransform[this.noverviews];
        this.overviewsTransformation[0] = new AffineTransform();
        int[] dims = this.getDimsAtMag(LTIUtils.levelToMag((int)0));
        int dimLastX = dims[0];
        int dimLastY = dims[1];
        for (int i = 1; i < this.noverviews; ++i) {
            dims = this.getDimsAtMag(LTIUtils.levelToMag((int)i));
            double scaleFactorX = (double)dims[0] / (double)dimLastX;
            double scaleFactorY = (double)dims[1] / (double)dimLastY;
            this.overviewsTransformation[i] = new AffineTransform(scaleFactorX, 0.0, 0.0, scaleFactorY, 0.0, 0.0);
        }
        this.metadata = this.getMetadata();
        double ox = 0.0;
        double oy = 0.0;
        double resx = 0.0;
        double resy = 0.0;
        LTIGeoCoord geoc = this.getGeoCoord();
        ox = geoc.getX();
        oy = geoc.getY();
        resx = geoc.getXRes();
        resy = geoc.getYRes();
        this.ownTransformation = new AffineTransform(resx, 0.0, 0.0, resy, ox, oy);
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        this.currentFullWidth = this.width;
        this.currentFullHeight = this.height;
        this.blocksize = this.getStripHeight();
        if (this.nbands == 1) {
            this.bBandNr = 1;
            this.gBandNr = 1;
            this.rBandNr = 1;
        }
        if (this.nbands == 2) {
            this.gBandNr = 1;
            this.rBandNr = 1;
            this.bBandNr = 2;
        }
    }

    public void setAlpha(int a) {
        this.alpha = a;
    }

    public void setDataType(int dt) {
        this.dataType = dt;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        try {
            this.externalTransformation.inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public Point2D rasterToWorld(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        this.externalTransformation.transform(pt, p);
        return p;
    }

    public void setView(double ulx, double uly, double lrx, double lry, int nWidth, int nHeight) {
        this.currentImageView[0] = ulx;
        this.currentImageView[1] = uly;
        this.currentImageView[2] = lrx;
        this.currentImageView[3] = lry;
        this.overviewFullWidth = this.currentFullWidth = this.width;
        this.overviewFullHeight = this.currentFullHeight = this.height;
        Point2D a = this.worldToRaster(new Point2D.Double(ulx, uly));
        Point2D b = this.worldToRaster(new Point2D.Double(lrx, lry));
        Point2D tl = new Point2D.Double(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()));
        Point2D br = new Point2D.Double(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()));
        this.currentViewWidth = nWidth;
        this.currentViewHeight = nHeight;
        this.currentViewX = tl.getX();
        this.currentViewY = tl.getY();
        this.viewportScaleX = (double)this.currentViewWidth / (br.getX() - tl.getX());
        this.viewportScaleY = (double)this.currentViewHeight / (br.getY() - tl.getY());
        try {
            int[] dims = null;
            double zoom = 1.0;
            this.zoomoverview = 1.0;
            if (WITH_OVERVIEWS && this.noverviews - 1 > 0) {
                for (int i = this.noverviews - 1; i > 0; --i) {
                    zoom = LTIUtils.levelToMag((int)i);
                    dims = this.getDimsAtMag(zoom);
                    if (!((double)dims[0] > (double)this.getWidth() * this.viewportScaleX)) continue;
                    this.zoomoverview = zoom;
                    this.viewportScaleX /= this.zoomoverview;
                    this.viewportScaleY /= this.zoomoverview;
                    this.overviewFullWidth = this.currentFullWidth = dims[0];
                    this.overviewFullHeight = this.currentFullHeight = dims[1];
                    tl = this.worldToRaster(new Point2D.Double(ulx, uly));
                    br = this.worldToRaster(new Point2D.Double(lrx, lry));
                    tl.setLocation(Math.min(tl.getX(), br.getX()), Math.min(tl.getY(), br.getY()));
                    this.overviewsTransformation[i].transform(tl, tl);
                    this.currentFullWidth = this.width;
                    this.currentFullHeight = this.height;
                    this.currentViewX = tl.getX();
                    this.currentViewY = tl.getY();
                    break;
                }
            }
            this.setDataType(this.eSampleType);
        }
        catch (MrSIDException e) {
            e.printStackTrace();
        }
    }

    void pintaInfo() {
        try {
            System.out.println("GeoTransform:");
            LTIGeoCoord geoc = this.getGeoCoord();
            System.out.println("  param[0]=" + geoc.getX());
            System.out.println("  param[0]=" + geoc.getY());
            System.out.println("  param[0]=" + geoc.getXRes());
            System.out.println("  param[0]=" + geoc.getYRes());
            System.out.println("  param[0]=" + geoc.getXRot());
            System.out.println("  param[0]=" + geoc.getYRot());
            System.out.println("Metadata:");
            LTIMetadataDatabase metadata = this.getMetadata();
            for (int i = 0; i < metadata.getIndexCount(); ++i) {
                int j;
                String[] s;
                LTIMetadataRecord rec = null;
                rec = metadata.getDataByIndex(i);
                System.out.println(rec.getTagName());
                if (rec.isScalar()) {
                    System.out.println(rec.getScalarData());
                    continue;
                }
                if (rec.isVector()) {
                    s = rec.getVectorData();
                    for (j = 0; j < s.length; ++j) {
                        System.out.println("V" + j + "->" + s[j]);
                    }
                    continue;
                }
                if (rec.isArray()) {
                    s = rec.getArrayData();
                    for (j = 0; j < s.length; ++j) {
                        System.out.println("A" + j + "->" + s[j]);
                    }
                    continue;
                }
                System.out.println("");
            }
        }
        catch (MrSIDException e) {
            e.printStackTrace();
        }
    }

    public LTISceneBuffer readBuffer(int x, int y, int SceneWidth, int SceneHeight) throws MrSIDException {
        LTISceneBuffer buffer = this.readScene(x, y, SceneWidth, SceneHeight, this.zoomoverview, this, SceneWidth, SceneHeight, true);
        return buffer;
    }

    public void readScene(int[] line, RasterTask task) throws MrSIDException, ProcessInterruptedException {
        int x = (int)Math.floor(this.currentViewX);
        int y = (int)Math.floor(this.currentViewY);
        int SceneWidth = 0;
        int SceneHeight = 0;
        SceneWidth = (int)Math.ceil((double)this.currentViewWidth / this.viewportScaleX + 1.0);
        SceneHeight = (int)Math.ceil((double)this.currentViewHeight / this.viewportScaleY + 1.0);
        while (x + SceneWidth > this.overviewFullWidth) {
            --SceneWidth;
        }
        while (y + SceneHeight > this.overviewFullHeight) {
            --SceneHeight;
        }
        if (SceneWidth == 0) {
            SceneWidth = 1;
        }
        if (SceneHeight == 0) {
            SceneHeight = 1;
        }
        LTISceneBuffer buffer = null;
        buffer = this.readScene(x, y, SceneWidth, SceneHeight, this.zoomoverview, this, SceneWidth, SceneHeight, true);
        if (task.getEvent() != null) {
            task.manageEvent(task.getEvent());
        }
        if (this.dataType == 1 || this.dataType == 2 || this.dataType == 4 || this.dataType == 6 || this.dataType == 3 || this.dataType == 5) {
            double scaleX = 1.0 / this.viewportScaleX;
            double scaleY = 1.0 / this.viewportScaleY;
            int alpha = (this.alpha & 0xFF) << 24;
            if (this.rBandNr == 1) {
                this.bandR = buffer.buf1;
            } else if (this.rBandNr == 2) {
                this.bandR = buffer.buf2;
            } else if (this.rBandNr == 3) {
                this.bandR = buffer.buf3;
            }
            if (this.gBandNr == 1) {
                this.bandG = buffer.buf1;
            } else if (this.gBandNr == 2) {
                this.bandG = buffer.buf2;
            } else if (this.gBandNr == 3) {
                this.bandG = buffer.buf3;
            }
            if (this.bBandNr == 1) {
                this.bandB = buffer.buf1;
            } else if (this.bBandNr == 2) {
                this.bandB = buffer.buf2;
            } else if (this.bBandNr == 3) {
                this.bandB = buffer.buf3;
            }
            double offsetX = Math.abs(this.currentViewX - (double)((int)this.currentViewX));
            double offsetY = Math.abs(this.currentViewY - (double)((int)this.currentViewY));
            for (int y1 = 0; y1 < this.currentViewHeight; ++y1) {
                for (int x1 = 0; x1 < this.currentViewWidth; ++x1) {
                    int kd = y1 * this.currentViewWidth + x1;
                    int k = (int)((double)y1 * scaleY + offsetY) * SceneWidth + (int)((double)x1 * scaleX + offsetX);
                    try {
                        line[kd] = alpha + ((0xFF & this.bandR[k]) << 16) + ((0xFF & this.bandG[k]) << 8) + (0xFF & this.bandB[k]);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
        }
        buffer = null;
    }

    public void readWindow(Buffer buf, BandList bandList, int x, int y, int w, int h, int bufWidth, int bufHeight) throws MrSIDException, ProcessInterruptedException {
        if (bufWidth > buf.getWidth()) {
            bufWidth = buf.getWidth();
        }
        if (bufHeight > buf.getHeight()) {
            bufHeight = buf.getHeight();
        }
        if (buf.isCached()) {
            int nBlocks = bufHeight / buf.getBlockHeight();
            int lastBlock = bufHeight - nBlocks * buf.getBlockHeight();
            int lastBlockSrc = lastBlock * h / bufHeight;
            int sizeBlockSrc = buf.getBlockHeight() * h / bufHeight;
            if (lastBlock > 0) {
                ++nBlocks;
            }
            int initSrc = y;
            int init = 0;
            for (int i = 0; i < nBlocks; ++i) {
                int[] stepDst;
                double[] stepSrc;
                if (lastBlock > 0 && i == nBlocks - 1) {
                    stepSrc = new double[]{x, initSrc, w, lastBlockSrc};
                    stepDst = new int[]{0, init, bufWidth, init + lastBlock};
                    this.readWindowInMemory(buf, bandList, stepSrc, stepDst, w, lastBlock);
                    continue;
                }
                stepSrc = new double[]{x, initSrc, w, sizeBlockSrc};
                stepDst = new int[]{0, init, bufWidth, init + buf.getBlockHeight()};
                this.readWindowInMemory(buf, bandList, stepSrc, stepDst, w, buf.getBlockHeight());
                init += buf.getBlockHeight();
                initSrc += sizeBlockSrc;
            }
        } else {
            this.readWindowInMemory(buf, bandList, x, y, w, h);
        }
    }

    public void readWindow(Buffer buf, BandList bandList, int x, int y) throws MrSIDException, ProcessInterruptedException {
        int h;
        int w = x + buf.getWidth() > this.getWidth() ? this.getWidth() - x : buf.getWidth();
        int n = h = y + buf.getHeight() > this.getHeight() ? this.getHeight() - y : buf.getHeight();
        if (buf.isCached()) {
            int nBlocks = buf.getHeight() / buf.getBlockHeight();
            int lastBlock = buf.getHeight() - nBlocks * buf.getBlockHeight();
            if (lastBlock > 0) {
                ++nBlocks;
            }
            int initYSrc = y;
            int initYBuffer = 0;
            for (int i = 0; i < nBlocks; ++i) {
                int[] stepDst;
                double[] stepSrc;
                if (lastBlock > 0 && i == nBlocks - 1) {
                    stepSrc = new double[]{x, initYSrc, w, lastBlock};
                    stepDst = new int[]{0, initYBuffer, w, initYBuffer + lastBlock};
                    this.readWindowInMemory(buf, bandList, stepSrc, stepDst, w, lastBlock);
                    continue;
                }
                stepSrc = new double[]{x, initYSrc, w, buf.getBlockHeight()};
                stepDst = new int[]{0, initYBuffer, w, initYBuffer + buf.getBlockHeight()};
                this.readWindowInMemory(buf, bandList, stepSrc, stepDst, w, buf.getBlockHeight());
                initYSrc += buf.getBlockHeight();
                initYBuffer += buf.getBlockHeight();
            }
        } else {
            this.readWindowInMemory(buf, bandList, x, y, w, h);
        }
    }

    private void readWindowInMemory(Buffer buf, BandList bandList, double[] srcPxPos, int[] stepDst, int sizeSrcX, int sizeSrcY) throws MrSIDException, ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        this.isSupersampling = false;
        LTISceneBuffer buffer = this.readScene(srcPxPos[0], srcPxPos[1], srcPxPos[2], srcPxPos[3], 1.0, this, sizeSrcX, sizeSrcY, true);
        byte[] bandBuf = null;
        for (int iBand = 0; iBand < this.getNumBands(); ++iBand) {
            int[] drawableBands = bandList.getBufferBandToDraw(this.fileName, iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            switch (iBand) {
                case 0: {
                    bandBuf = buffer.buf1;
                    break;
                }
                case 1: {
                    bandBuf = buffer.buf2;
                    break;
                }
                case 2: {
                    bandBuf = buffer.buf3;
                }
            }
            int lineSrc = 0;
            for (int line = stepDst[1]; line < stepDst[3]; ++line) {
                int colSrc = 0;
                for (int col = stepDst[0]; col < stepDst[2]; ++col) {
                    int kd = (int)((double)lineSrc * srcPxPos[2] + (double)colSrc);
                    buf.setElem(line, col, iBand, bandBuf[kd]);
                    ++colSrc;
                }
                ++lineSrc;
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
        }
    }

    private void readWindowInMemory(Buffer buf, BandList bandList, int x, int y, int w, int h) throws MrSIDException, ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        this.isSupersampling = false;
        LTISceneBuffer buffer = this.readScene(x, y, w, h, 1.0, this, w, h, true);
        byte[] bandBuf = null;
        for (int iBand = 0; iBand < this.getNumBands(); ++iBand) {
            int[] drawableBands = bandList.getBufferBandToDraw(this.fileName, iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            switch (iBand) {
                case 0: {
                    bandBuf = buffer.buf1;
                    break;
                }
                case 1: {
                    bandBuf = buffer.buf2;
                    break;
                }
                case 2: {
                    bandBuf = buffer.buf3;
                }
            }
            for (int line = 0; line < h; ++line) {
                for (int col = 0; col < w; ++col) {
                    int kd = line * w + col;
                    buf.setElem(line, col, iBand, bandBuf[kd]);
                }
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
        }
    }

    public byte[] getWindow(int ulX, int ulY, int sizeX, int sizeY, int band) throws MrSIDException {
        LTISceneBuffer buffer = this.readScene(ulX, ulY, sizeX, sizeY, 1.0, this, sizeX, sizeY, true);
        if (band == 1) {
            return buffer.buf1;
        }
        if (band == 2) {
            return buffer.buf2;
        }
        if (band == 3) {
            return buffer.buf3;
        }
        return null;
    }

    public Object[] getData(int x, int y) {
        try {
            Object[] data = new Object[this.nbands];
            block10: for (int i = 0; i < this.nbands; ++i) {
                byte[] b = this.getWindow(x, y, 1, 1, this.nbands);
                switch (this.dataType) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        data[i] = new Integer(b[0]);
                        continue block10;
                    }
                    case 2: 
                    case 3: {
                        data[i] = new Integer(b[0]);
                        continue block10;
                    }
                    case 4: 
                    case 5: {
                        data[i] = new Integer(b[0]);
                        continue block10;
                    }
                    case 6: {
                        data[i] = new Float(b[0]);
                        continue block10;
                    }
                    case 7: {
                        data[i] = new Double(b[0]);
                    }
                }
            }
            return data;
        }
        catch (MrSIDException e) {
            return null;
        }
    }

    public void setExternalTransform(AffineTransform t) {
        this.externalTransformation = t;
    }

    public AffineTransform getOwnTransformation() {
        return this.ownTransformation;
    }
}

