/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.utils;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.CompatLocator;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.parser.IGPEErrorHandler;
import org.gvsig.gpe.lib.impl.warnings.SrsUnknownWarning;

public class GmlProjectionFactory {
    private static GPEManager gpeManager = GPELocator.getGPEManager();

    public static String fromGPEToGML(String srs, IGPEErrorHandler errorHandler) {
        if (srs != null) {
            if (!gpeManager.getBooleanProperty("srsBasedOnXml")) {
                return srs;
            }
            String[] parts = CompatLocator.getStringUtils().split(srs, ":");
            if (parts.length == 2) {
                if (parts[0].compareTo("EPSG") == 0) {
                    return "http://www.opengis.net/gml/srs/epsg.xml#" + parts[1];
                }
            } else if (parts.length == 1) {
                return "http://www.opengis.net/gml/srs/epsg.xml#" + parts[0];
            }
        }
        errorHandler.addWarning((Throwable)new SrsUnknownWarning(srs));
        return "unknown";
    }

    public static String fromGMLToGPE(String srs, IGPEErrorHandler errorHandler) {
        if (StringUtils.startsWith((CharSequence)srs, (CharSequence)"urn:x-ogc:def:crs:")) {
            return srs;
        }
        if (srs != null) {
            String[] parts = CompatLocator.getStringUtils().split(srs, "#");
            if (parts.length == 2) {
                if (parts[0].compareTo("http://www.opengis.net/gml/srs/epsg.xml") == 0) {
                    return "EPSG:" + parts[1];
                }
            } else if (parts.length == 1 && (parts = CompatLocator.getStringUtils().split(srs, "/")).length > 1) {
                return "EPSG:" + parts[parts.length - 1];
            }
        }
        errorHandler.addWarning((Throwable)new SrsUnknownWarning(srs));
        return "unknown";
    }
}

