/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.spi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;

public class DefaultEditingServiceParameter
implements EditingServiceParameter {
    private String name;
    private String description;
    private Set<EditingServiceParameter.TYPE> types;
    private int geometryType;
    private Map<String, String> options;
    private EditingServiceParameterOptions options2;
    private Object defaultValue;
    private boolean optional;
    private int dataType;
    private boolean allowNull;

    public DefaultEditingServiceParameter(String theName, String theDescription, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, null, null, null, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, boolean optional, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, null, null, null, optional, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, Map<String, String> options, Object defaultValue, boolean optional, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, options, defaultValue, optional, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, EditingServiceParameterOptions options, Object defaultValue, boolean optional, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, options, defaultValue, optional, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, Object theDefaultValue, String theDescription, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, null, null, theDefaultValue, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, int theGeometryType, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, theGeometryType, null, null, null, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, Object theDefaultValue, int theGeometryType, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, theGeometryType, null, null, theDefaultValue, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, Map<String, String> theOptions, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, theOptions, null, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, Map<String, String> theOptions, Object theDefaultValue, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, theOptions, theDefaultValue, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, EditingServiceParameterOptions theOptions, Object theDefaultValue, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, 16, null, theOptions, theDefaultValue, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, int theGeometryType, Map<String, String> theOptions, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, theGeometryType, theOptions, null, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, int theGeometryType, Map<String, String> theOptions, Object theDefaultValue, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, theGeometryType, theOptions, theDefaultValue, false, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, int theGeometryType, Map<String, String> theOptions, Object theDefaultValue, boolean optional, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, theGeometryType, theOptions, null, theDefaultValue, optional, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, int theGeometryType, EditingServiceParameterOptions theOptions, Object theDefaultValue, boolean optional, EditingServiceParameter.TYPE ... theTypes) {
        this(theName, theDescription, theGeometryType, null, theOptions, theDefaultValue, optional, theTypes);
    }

    public DefaultEditingServiceParameter(String theName, String theDescription, int theGeometryType, Map<String, String> theOptions, EditingServiceParameterOptions theOptions2, Object theDefaultValue, boolean optional, EditingServiceParameter.TYPE ... theTypes) {
        this.name = theName;
        this.description = theDescription;
        this.geometryType = theGeometryType;
        this.types = new HashSet<EditingServiceParameter.TYPE>();
        this.types.addAll(Arrays.asList(theTypes));
        this.options = theOptions;
        this.options2 = theOptions2;
        this.defaultValue = theDefaultValue;
        this.optional = optional;
        this.dataType = 8;
        this.allowNull = true;
    }

    public Set<EditingServiceParameter.TYPE> getTypes() {
        return this.types;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public int getGeometryType() {
        return this.geometryType;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public EditingServiceParameterOptions getOptions2() {
        return this.options2;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object value) {
        this.defaultValue = value;
    }

    public String getConsoleDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        if (this.defaultValue instanceof Point) {
            Point point = (Point)this.defaultValue;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < point.getDimension(); ++i) {
                builder.append(point.getCoordinateAt(i));
                if (i >= point.getDimension() - 1) continue;
                builder.append(" , ");
            }
            return builder.toString();
        }
        if (this.options2 != null) {
            return this.options2.getConsoleValue(this.defaultValue);
        }
        if (this.options != null) {
            return this.options.getOrDefault(this.defaultValue, "");
        }
        return Objects.toString(this.defaultValue, "");
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public DefaultEditingServiceParameter setDataType(int dataType) {
        this.dataType = dataType;
        return this;
    }

    public int getDataType() {
        return this.dataType;
    }

    public DefaultEditingServiceParameter setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
        return this;
    }

    public boolean getAllowNull() {
        return this.allowNull;
    }

    public boolean isValidValue(Object value) {
        if (value == null) {
            return this.allowNull;
        }
        for (EditingServiceParameter.TYPE type : this.types) {
            switch (type) {
                case GEOMETRY: {
                    if (!(value instanceof Geometry)) break;
                    return true;
                }
                case POSITION: {
                    if (!(value instanceof Point)) break;
                    return true;
                }
                case LIST_POSITIONS: {
                    if (!(value instanceof Point)) break;
                    return true;
                }
                case OPTION: {
                    try {
                        Object v = value instanceof String && StringUtils.isBlank((CharSequence)((String)value)) ? this.defaultValue : null;
                        this.options2.getValue(value, v);
                        return true;
                    }
                    catch (InvalidEntryException v) {
                        break;
                    }
                }
                case SELECTION: {
                    if (!(value instanceof FeatureSelection)) break;
                    return true;
                }
                case MULTILAYER_SELECTION: {
                    if (!(value instanceof Geometry) && !(value instanceof List)) break;
                    return true;
                }
                case DISTANCE: {
                    if (!(value instanceof Double)) break;
                    return true;
                }
                case CLIPBOARD: {
                    return true;
                }
                case VALUE: {
                    DataTypesManager manager = ToolsLocator.getDataTypesManager();
                    DataType dtype = manager.get(this.dataType);
                    if (dtype.isObject()) break;
                    try {
                        Object v = dtype.coerce(value);
                        return true;
                    }
                    catch (CoercionException coercionException) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    public Object coerceValue(Object value) {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        DataType dtype = manager.get(this.dataType);
        try {
            Object v = dtype.coerce(value);
            return v;
        }
        catch (CoercionException ex) {
            throw new IllegalArgumentException("Illegal value '" + Objects.toString(value) + "' for parameter '" + this.getName() + "'", ex);
        }
    }
}

