/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.SymbolImageButton;
import gishur.awt.SymbolImageStatusButton;
import gishur.awt.SymbolSpinCombo;
import gishur.awt.SymbolSpinNumCombo;
import gishur.awt.Symbolbar;
import gishur.awt.SymbolbarLabel;
import gishur.awt.SymbolbarSeparator;
import gishur.awt.SymbolbarSlider;
import gishur.awt.images.TraceSymbols;
import gishur.core.Switch;
import gishur.core.algorithms.TraceExecutor;
import gishur.core.algorithms.TraceLabel;
import gishur.core.algorithms.TraceVisualizer;
import gishur.core.algorithms.Tracer;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public class TraceBar
extends Symbolbar
implements Runnable {
    public static final String home_com = "trace_go_start";
    public static final String end_com = "trace_go_end";
    public static final String start_com = "trace_start";
    public static final String power_com = "trace_power";
    public static final String next_com = "trace_step_forward";
    public static final String prev_com = "trace_step_back";
    public static final String level_com = "trace_changed_level";
    public static final String slider_com = "trace_slider_changed";
    public static final String speed_com = "trace_speed_changed";
    private SymbolImageStatusButton _power;
    private SymbolImageStatusButton _start;
    private SymbolImageButton _go_start;
    private SymbolImageButton _go_end;
    private SymbolImageButton _prev;
    private SymbolImageButton _next;
    private SymbolbarSlider _slider;
    private SymbolSpinNumCombo _level;
    private SymbolSpinCombo _speed;
    private SymbolbarLabel _level_text;
    private SymbolbarLabel _speed_text;
    private static final int USE_BEFORE_FIRST_STEP = 1;
    private static final int USE_AFTER_LAST_STEP = 2;
    private static final int THREAD_ALGORITHM_EXECUTION = 4;
    private static final int GO_BACK_ON_LEVEL_DOWN = 8;
    private static final int NORMAL_MODE = 3;
    private int _mode = 3;
    private long _pause_time = 500L;
    private Tracer _tracer;
    private int _laststep = -1;
    private TraceExecutor _executor = null;
    private TraceVisualizer _visualizer = null;
    private TraceLabel[] _labels = new TraceLabel[0];

    public void switchOff() {
        if (this._power.status() == 0) {
            return;
        }
        this.pausePlayback();
        this.setButtonStatus();
        this._power.setButton(false);
        this._power.setStatus(0);
        this.setButtonStatus();
        if (this._visualizer != null) {
            this._visualizer.clearVisualization();
        }
    }

    private void setButtonStatus() {
        if (this._power.status() == 0) {
            this._power.enable();
            this._start.disable();
            this._go_start.disable();
            this._go_end.disable();
            this._prev.disable();
            this._next.disable();
            this._slider.disable();
            this._level.disable();
            this._level_text.disable();
            this._speed.disable();
            this._speed_text.disable();
        } else {
            this._power.enable();
            this._start.enable();
            this._level.enable();
            this._level_text.enable();
            this._slider.enable();
            this._speed.enable();
            this._speed_text.enable();
            if (this._slider.value() == 0) {
                this._prev.disable();
                this._go_start.disable();
            } else {
                this._prev.enable();
                this._go_start.enable();
            }
            if (this._slider.value() >= this._slider.maxValue()) {
                this._next.disable();
                this._go_end.disable();
            } else {
                this._next.enable();
                this._go_end.enable();
            }
        }
        this.repaint();
    }

    public void setUseThreadForExecution(boolean bl) {
        if (bl) {
            this._mode |= 4;
            return;
        }
        this._mode &= 0xFFFFFFFB;
    }

    public boolean useAfterLastStep() {
        return (this._mode & 2) != 0;
    }

    private void exec_algorithm() {
        this._tracer.startRecord();
        this._executor.execute(this._tracer);
        this._tracer.stopRecord();
        this._laststep = -1;
        this.fill_slider();
    }

    public TraceBar(String string) {
        super(string, 30);
        this.init();
        new Thread((Runnable)this, this.getClass().getName() + "-Visualizer-Thread").start();
    }

    public void setTraceVisualizer(TraceVisualizer traceVisualizer) {
        this._visualizer = traceVisualizer;
        if (this._power.status() != 0) {
            this._visualizer.initVisualization();
            this.visualize();
        }
    }

    public void setPlaybackFPS(float f) {
        this._pause_time = (long)(1000.0f / f);
    }

    public float playbackFPS() {
        return 1000.0f / (float)this._pause_time;
    }

    public void setGoBackOnLevelDown(boolean bl) {
        if (bl) {
            this._mode |= 8;
            return;
        }
        this._mode &= 0xFFFFFFF7;
    }

    public boolean useThreadForExecution() {
        return (this._mode & 4) != 0;
    }

    public void setUseBeforeFirstStep(boolean bl) {
        if (bl) {
            this._mode |= 1;
            return;
        }
        this._mode &= 0xFFFFFFFE;
    }

    public void processActionEvent(ActionEvent actionEvent) {
        super.processActionEvent(actionEvent);
        this.doCommand(actionEvent.getActionCommand());
    }

    public void setPlaybackSpeed(long l) {
        this._pause_time = l;
    }

    public boolean useBeforeFirstStep() {
        return (this._mode & 1) != 0;
    }

    public void doCommand(String string) {
        if (string == power_com) {
            if (this._power.status() == 0) {
                this.switchOn();
                return;
            }
            this.switchOff();
            return;
        }
        if (this._power.status() == 1) {
            switch (Switch.objects(string, start_com, home_com, prev_com, slider_com, next_com, end_com, level_com, speed_com)) {
                case 0: {
                    if (this._start.status() == 0) {
                        this._start.setStatus(1);
                        if (this._slider.value() >= this._slider.maxValue()) {
                            this._slider.setValueTo(0);
                        }
                        this.visualize();
                        break;
                    }
                    this.pausePlayback();
                    break;
                }
                case 1: {
                    this._slider.setValueTo(0);
                    this.visualize();
                    break;
                }
                case 2: {
                    this._slider.setValueTo(this._slider.value() - 1);
                    this.visualize();
                    break;
                }
                case 4: {
                    this._slider.setValueTo(this._slider.value() + 1);
                    this.visualize();
                    break;
                }
                case 5: {
                    this._slider.setValueTo(this._slider.maxValue());
                    this.visualize();
                    break;
                }
                case 3: {
                    this.visualize();
                    break;
                }
                case 6: {
                    this.changeLevel();
                    break;
                }
                case 7: {
                    this.setPlaybackFPS(Float.valueOf(this._speed.labels()[this._speed.index()]).floatValue());
                }
            }
            this.setButtonStatus();
        }
    }

    public void setButtonLabels(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (string != null) {
            this._power.setLabel(string);
        }
        if (string2 != null) {
            this._start.setLabel(string2);
        }
        if (string3 != null) {
            this._go_start.setLabel(string3);
        }
        if (string4 != null) {
            this._prev.setLabel(string4);
        }
        if (string5 != null) {
            this._slider.setLabel(string5);
        }
        if (string6 != null) {
            this._next.setLabel(string6);
        }
        if (string7 != null) {
            this._go_end.setLabel(string7);
        }
        if (string8 != null) {
            this._level.setLabel(string8);
            this._level_text.setLabel(string8);
        }
    }

    public void setButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.clearAll();
        if (bl) {
            this.add(this._power);
            if (bl2) {
                this.add(new SymbolbarSeparator());
            }
        }
        if (bl2) {
            this.add(this._start);
        }
        if ((bl2 || bl) && (bl3 || bl4 || bl5 || bl6 || bl7 || bl8)) {
            this.add(new SymbolbarSeparator());
        }
        if (bl3) {
            this.add(this._go_start);
        }
        if (bl4) {
            this.add(this._prev);
        }
        if (bl5) {
            this.add(this._slider);
        }
        if (bl6) {
            this.add(this._next);
        }
        if (bl7) {
            this.add(this._go_end);
        }
        if (bl8) {
            if (bl3 || bl4 || bl5 || bl6 || bl7) {
                this.add(new SymbolbarSeparator());
            }
            this.add(this._level_text);
            this.add(this._level);
        }
        if (bl9) {
            if (bl8 || bl3 || bl4 || bl5 || bl6 || bl7 || bl2 || bl) {
                this.add(new SymbolbarSeparator());
            }
            this.add(this._speed_text);
            this.add(this._speed);
        }
        this.setButtonStatus();
    }

    public boolean goBackOnLevelDown() {
        return (this._mode & 8) != 0;
    }

    public void switchOn() {
        if (this._power.status() == 1) {
            return;
        }
        if (this._executor == null) {
            this._power.setButton(false);
            this._power.setStatus(0);
            this.repaint();
            return;
        }
        this._power.setButton(true);
        this._power.setStatus(1);
        this._level.setMinMax(0, this._executor.getMaxUsedLevel());
        this.exec_algorithm();
        this.setButtonStatus();
        if (this._visualizer != null) {
            this._visualizer.initVisualization();
            this.visualize();
        }
    }

    public void enableBar() {
        this._power.enable();
        this.repaint();
    }

    public void disableBar() {
        this.switchOff();
        this._power.disable();
        this.repaint();
    }

    public void setUseAfterLastStep(boolean bl) {
        if (bl) {
            this._mode |= 2;
            return;
        }
        this._mode &= 0xFFFFFFFD;
    }

    private void fill_slider() {
        int n = (this._mode & 1) != 0 ? 1 : 0;
        int n2 = (this._mode & 2) != 0 ? 1 : 0;
        this._labels = this._tracer.getTraceLabels(this._level.value());
        if (n + n2 > 0) {
            TraceLabel[] traceLabelArray = this._labels;
            this._labels = new TraceLabel[traceLabelArray.length + n + n2];
            System.arraycopy(traceLabelArray, 0, this._labels, n, traceLabelArray.length);
        }
        this._slider.setMaxValue(this._labels.length - 1);
    }

    public void run() {
        float f = 1.0f;
        int n = 0;
        while (true) {
            Object var6_8;
            TraceLabel traceLabel;
            TraceBar traceBar = this;
            synchronized (traceBar) {
                block17: {
                    if (this._start.status() != 1) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            System.out.println(Thread.currentThread() + ".run():" + exception);
                        }
                    }
                    if ((n = this._slider.value()) >= 0 && n < this._labels.length) {
                        traceLabel = this._labels[n];
                        break block17;
                    }
                    traceLabel = null;
                    n = -1;
                }
                var6_8 = null;
            }
            if (n >= 0 && n != this._laststep && this._visualizer != null) {
                this._laststep = n;
                f = traceLabel == null ? (this._laststep == 0 ? this._visualizer.visualizeBeforeFirst(this._labels[1]) : this._visualizer.visualizeAfterLast(this._labels[this._labels.length - 2])) : this._visualizer.visualize(traceLabel);
            }
            if (this._start.status() != 1) continue;
            if (f < 0.0f) {
                f = 1.0f;
            }
            traceBar = this;
            synchronized (traceBar) {
                try {
                    this.wait(Math.max(1, (int)((float)this._pause_time * f)));
                }
                catch (Exception exception) {
                    System.out.println(Thread.currentThread() + ".run():" + exception);
                }
                var6_8 = null;
            }
            if (this._laststep >= this._slider.maxValue()) {
                this.pausePlayback();
            } else {
                this._slider.setValueTo(this._slider.value() + 1);
            }
            this.setButtonStatus();
        }
    }

    private void init() {
        this._tracer = new Tracer("TraceBar Tracer");
        Image image = TraceSymbols.createImage();
        this._power = new SymbolImageStatusButton("Power", power_com, image, image, 2, true);
        this._power.setStatus(0, "Power On", new Rectangle(176, 0, 18, 18), new Rectangle(212, 0, 18, 18));
        this._power.setStatus(1, "Power Off", new Rectangle(194, 0, 18, 18), new Rectangle(212, 0, 18, 18));
        this._start = new SymbolImageStatusButton("Start", start_com, image, image, 2, true);
        this._start.setStatus(0, "Start", new Rectangle(27, 0, 18, 18), new Rectangle(117, 0, 18, 18));
        this._start.setStatus(1, "Pause", new Rectangle(40, 0, 18, 18), new Rectangle(130, 0, 18, 18));
        this._go_start = new SymbolImageButton("Go Start", home_com, image, new Rectangle(0, 0, 18, 18), image, new Rectangle(90, 0, 18, 18), false);
        this._prev = new SymbolImageButton("Step Back", prev_com, image, new Rectangle(14, 0, 18, 18), image, new Rectangle(104, 0, 18, 18), false);
        this._slider = new SymbolbarSlider("Step", slider_com, 50, 1);
        this._slider.setNumberedValues(0);
        this._next = new SymbolImageButton("Step Forward", next_com, image, new Rectangle(55, 0, 18, 18), image, new Rectangle(145, 0, 18, 18), false);
        this._go_end = new SymbolImageButton("Go End", end_com, image, new Rectangle(72, 0, 18, 18), image, new Rectangle(160, 0, 18, 18), false);
        this._level = new SymbolSpinNumCombo("Trace Level", level_com, 30, 0, 0, 0);
        this._level_text = new SymbolbarLabel("Level:", "Trace Level", 40, true);
        this._level_text.back_color = this.getBackground();
        this._speed_text = new SymbolbarLabel("Speed:", "Playback Speed", 45, true);
        this._speed = new SymbolSpinCombo("Playback Speed", speed_com, 40, new String[]{"0.2", "0.5", "1", "2", "4", "8", "16"}, 3);
        this._speed_text.back_color = this.getBackground();
        this.setButtons(true, true, true, true, true, true, true, true, true);
    }

    public long playbackSpeed() {
        return this._pause_time;
    }

    private void changeLevel() {
        TraceLabel traceLabel = this._labels[this._slider.value()];
        boolean bl = this._slider.value() == this._slider.maxValue();
        this.fill_slider();
        this._laststep = -1;
        if (bl) {
            this._slider.setValueTo(this._slider.maxValue());
        } else {
            int n = 0;
            this._slider.setValueTo(0);
            while (traceLabel != null) {
                n = 0;
                while (n < this._labels.length && this._labels[n] != traceLabel) {
                    ++n;
                }
                if (n < this._labels.length) {
                    this._slider.setValueTo(n);
                    traceLabel = null;
                    continue;
                }
                traceLabel = (this._mode & 8) != 0 ? traceLabel.prevUp() : traceLabel.nextUp();
            }
        }
        this.setButtonStatus();
        this.visualize();
    }

    private void pausePlayback() {
        this._start.setStatus(0);
        this._start.setButton(false);
    }

    private final synchronized void visualize() {
        this.notifyAll();
    }

    public void setTraceExecutor(TraceExecutor traceExecutor) {
        this._executor = traceExecutor;
        if (traceExecutor == null) {
            this.switchOff();
            return;
        }
        int n = traceExecutor.getMaxUsedLevel();
        if (n < 0) {
            this._level.disable();
        } else {
            this._level.setMinMax(0, n);
            this._level.setValue(this._level.max());
        }
        if (this._power.status() != 0) {
            this.exec_algorithm();
            this.setButtonStatus();
        }
    }

    public void generateMenu(Menu menu) {
        boolean bl;
        boolean bl2 = this._power.getParent() != null;
        boolean bl3 = this._start.getParent() != null;
        boolean bl4 = this._go_start.getParent() != null;
        boolean bl5 = this._go_end.getParent() != null;
        boolean bl6 = this._prev.getParent() != null;
        boolean bl7 = bl = this._next.getParent() != null;
        if (bl2) {
            menu.add(this._power.generateMenuItem());
            if (bl3) {
                menu.add(new MenuItem("-"));
            }
        }
        if (bl3) {
            menu.add(this._start.generateMenuItem());
        }
        if ((bl3 || bl2) && (bl4 || bl5 || bl6 || bl)) {
            menu.add(new MenuItem("-"));
        }
        if (bl4) {
            menu.add(this._go_start.generateMenuItem());
        }
        if (bl6) {
            menu.add(this._prev.generateMenuItem());
        }
        if (bl) {
            menu.add(this._next.generateMenuItem());
        }
        if (bl5) {
            menu.add(this._go_end.generateMenuItem());
        }
    }
}

