/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.Cloneable;
import gishur.core.ControlledCloneable;
import gishur.core.Owner;
import gishur.core.TreeItem;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;

public class BasicTreeItem
implements TreeItem,
ControlledCloneable,
Serializable {
    private Owner _owningTree = null;
    private TreeItem _parent = null;
    private TreeItem[] _child = null;
    private byte _balance = 0;

    public TreeItem child(int n) {
        if (n > this._child.length) {
            return null;
        }
        if (n < 0) {
            if (n == -1) {
                return this._parent;
            }
            if (n == -2) {
                return this._child[this._child.length - 1];
            }
            return null;
        }
        return this._child[n];
    }

    public int pos(TreeItem treeItem) {
        if (this._parent == treeItem) {
            return -1;
        }
        int n = 0;
        while (n < this._child.length && this._child[n] != treeItem) {
            ++n;
        }
        if (n >= this._child.length) {
            return -3;
        }
        return n;
    }

    public synchronized boolean clearConnections() {
        if (!this.requestTreeAccess(3, null)) {
            return false;
        }
        int n = 0;
        while (n < this._child.length) {
            this._child[n] = null;
            ++n;
        }
        this._parent = null;
        this._balance = 0;
        return true;
    }

    public boolean setBalance(byte by) {
        if (!this.requestTreeAccess(104, new Byte(by))) {
            return false;
        }
        this._balance = by;
        return true;
    }

    public Object value() {
        return null;
    }

    public TreeItem parent() {
        return this._parent;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.key() == object) {
            return true;
        }
        if (object.equals(this.key())) {
            return true;
        }
        if (object instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)object;
            if (this.key() == treeItem.key()) {
                return true;
            }
            if (this.key() == null || treeItem.key() == null) {
                return false;
            }
            return this.key().equals(treeItem.key());
        }
        return false;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public boolean setKey(Object object) {
        return false;
    }

    public Object clone() {
        return this.clone(null, -1);
    }

    public Object clone(Hashtable hashtable, int n) {
        BasicTreeItem basicTreeItem;
        try {
            if (hashtable == null && n != 1) {
                hashtable = new Hashtable<BasicTreeItem, BasicTreeItem>();
            }
            if (hashtable.containsKey(this)) {
                return hashtable.get(this);
            }
            basicTreeItem = (BasicTreeItem)super.clone();
            if (hashtable != null) {
                hashtable.put(this, basicTreeItem);
            }
            basicTreeItem._parent = null;
            if (this._child != null) {
                basicTreeItem._child = new TreeItem[this._child.length];
            }
            basicTreeItem._balance = 0;
            basicTreeItem._owningTree = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error while cloning");
        }
        if (n != 1) {
            if (n >= 0) {
                --n;
            }
            Object object = this.value();
            Object object2 = this.key();
            boolean bl = object2 != object;
            object2 = BasicTreeItem.cloneObject(object2, hashtable, n);
            basicTreeItem.setKey(object2);
            basicTreeItem.setValue(bl ? BasicTreeItem.cloneObject(object, hashtable, n) : object2);
        }
        return basicTreeItem;
    }

    public int level() {
        int n = 0;
        TreeItem treeItem = this._parent;
        while (treeItem != null) {
            treeItem = treeItem.parent();
            ++n;
        }
        return n;
    }

    public synchronized boolean cut() {
        if (this._parent == null) {
            return true;
        }
        if (!this._parent.connect(null, this._parent.pos(this))) {
            return false;
        }
        this._parent = null;
        return true;
    }

    public TreeItem sibling() {
        if (this._parent == null) {
            return null;
        }
        int n = this._parent.pos(this);
        n = this._parent.maxRank() - 1 - n;
        return this._parent.child(n);
    }

    public int prevChildPos(int n) {
        if (n < 0) {
            n = this._child.length - 1;
        }
        while (n >= 0 && this._child[n] == null) {
            --n;
        }
        if (n < 0) {
            return -3;
        }
        return n;
    }

    public synchronized boolean remove() {
        if (this.rank() >= 2 || !this.requestTreeAccess(2, null)) {
            return false;
        }
        int n = this.nextChildPos(0);
        if (this._parent == null) {
            if (n >= 0) {
                if (!this._child[n].connect(null, -1)) {
                    return false;
                }
                this._child[n] = null;
            }
        } else {
            int n2 = this._parent.pos(this);
            if (n >= 0) {
                if (!this._parent.connect(this._child[n], n2)) {
                    return false;
                }
                this._child[n] = null;
            } else if (!this._parent.connect(null, n2)) {
                return false;
            }
        }
        this._balance = 0;
        return true;
    }

    public int rank() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._child.length) {
            if (this._child[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public synchronized boolean setMaxRank(int n) {
        if (n < 0) {
            return false;
        }
        if (!this.requestTreeAccess(103, new Integer(n))) {
            return false;
        }
        TreeItem[] treeItemArray = this._child;
        this._child = new TreeItem[n];
        int n2 = 0;
        while (n2 < n) {
            this._child[n2] = n2 < treeItemArray.length ? treeItemArray[n2] : null;
            ++n2;
        }
        return true;
    }

    protected boolean requestTreeAccess(int n, Object object) {
        if (this._owningTree == null) {
            return true;
        }
        return this._owningTree.requestAccess(n, this, object);
    }

    public synchronized boolean answerConnect(TreeItem treeItem, int n) {
        if (treeItem == null || treeItem.getOwningTree() != this.getOwningTree()) {
            return false;
        }
        if (treeItem.child(n) != this) {
            return false;
        }
        this._parent = treeItem;
        return true;
    }

    public boolean setValue(Object object) {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[balance=" + this._balance + "]";
    }

    public BasicTreeItem(int n) {
        this._child = new TreeItem[n];
    }

    public Object key() {
        return null;
    }

    public boolean isLeaf() {
        int n = 0;
        while (n < this._child.length && this._child[n] == null) {
            ++n;
        }
        return n >= this._child.length;
    }

    public int nextChildPos(int n) {
        if (n == -2) {
            return -3;
        }
        if (n < 0) {
            n = 0;
        }
        while (n < this._child.length && this._child[n] == null) {
            ++n;
        }
        if (n >= this._child.length) {
            return -3;
        }
        return n;
    }

    public boolean isInner() {
        return !this.isLeaf();
    }

    public byte balance() {
        return this._balance;
    }

    private static final Object cloneObject(Object object, Hashtable hashtable, int n) {
        block8: {
            if (object == null) {
                return null;
            }
            if (!(object instanceof java.lang.Cloneable)) {
                return object;
            }
            if (object instanceof ControlledCloneable) {
                return ((ControlledCloneable)object).clone(hashtable, n);
            }
            if (hashtable.containsKey(object)) {
                return hashtable.get(object);
            }
            if (object instanceof Cloneable) {
                Object object2 = ((Cloneable)object).clone();
                hashtable.put(object, object2);
                return object2;
            }
            try {
                Method method = object.getClass().getDeclaredMethod("clone", new Class[0]);
                if (Modifier.isPublic(method.getModifiers())) {
                    Object object3 = method.invoke(object, new Object[0]);
                    hashtable.put(object, object3);
                    return object3;
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof NullPointerException)) break block8;
                throw new InternalError("This shouldn't happen: Error while cloning");
            }
        }
        return object;
    }

    public synchronized boolean setOwningTree(Owner owner) {
        if (owner == this._owningTree) {
            return true;
        }
        if (!this.requestTreeAccess(1, owner)) {
            return false;
        }
        Owner owner2 = this._owningTree;
        this._owningTree = owner;
        if (!this.requestTreeAccess(1, owner)) {
            this._owningTree = owner2;
            return false;
        }
        return true;
    }

    public Owner getOwningTree() {
        return this._owningTree;
    }

    public int maxRank() {
        return this._child.length;
    }

    public synchronized boolean connect(TreeItem treeItem, int n) {
        if (treeItem != null && treeItem.getOwningTree() != this.getOwningTree()) {
            return false;
        }
        if (n > this._child.length) {
            return false;
        }
        if (n < 0) {
            if (!this.requestTreeAccess(101, treeItem)) {
                return false;
            }
            this._parent = null;
        } else {
            if (!this.requestTreeAccess(102, treeItem)) {
                return false;
            }
            TreeItem treeItem2 = this._child[n];
            this._child[n] = treeItem;
            if (treeItem != null && !treeItem.answerConnect(this, n)) {
                this._child[n] = treeItem2;
                return false;
            }
        }
        return true;
    }
}

